(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1159524,      25572]
NotebookOptionsPosition[   1156758,      25499]
NotebookOutlinePosition[   1157460,      25523]
CellTagsIndexPosition[   1157417,      25520]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L1odx", "=", 
   RowBox[{
    FractionBox["1", "2"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["x", "a"]}], ")"}]}]}], ";", 
  RowBox[{"L1ody", "=", 
   RowBox[{
    FractionBox["1", "2"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["y", "b"]}], ")"}]}]}], ";", 
  RowBox[{"L1odz", "=", 
   RowBox[{
    FractionBox["1", "2"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["z", "c"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L2odx", "=", 
   RowBox[{
    FractionBox["1", "2"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["x", "a"]}], ")"}]}]}], ";", 
  RowBox[{"L2ody", "=", 
   RowBox[{
    FractionBox["1", "2"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["y", "b"]}], ")"}]}]}], ";", 
  RowBox[{"L2odz", "=", 
   RowBox[{
    FractionBox["1", "2"], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["z", "c"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N1", "=", 
   RowBox[{"L1odx", "*", "L1ody", "*", "L1odz"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N2", "=", 
   RowBox[{"L2odx", "*", "L1ody", "*", "L1odz"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N3", "=", 
   RowBox[{"L2odx", "*", "L2ody", "*", "L1odz"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N4", "=", 
   RowBox[{"L1odx", "*", "L2ody", "*", "L1odz"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N5", "=", 
   RowBox[{"L1odx", "*", "L1ody", "*", "L2odz"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N6", "=", 
   RowBox[{"L2odx", "*", "L1ody", "*", "L2odz"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N7", "=", 
   RowBox[{"L2odx", "*", "L2ody", "*", "L2odz"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N8", "=", 
   RowBox[{"L1odx", "*", "L2ody", "*", "L2odz"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 = \>\"", ",", "N1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N2 = \>\"", ",", "N2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N3 = \>\"", ",", "N3"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N4 = \>\"", ",", "N4"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N5 = \>\"", ",", "N5"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N6 = \>\"", ",", "N6"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N7 = \>\"", ",", "N7"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N8 = \>\"", ",", "N8"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ni", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "N1", ",", "0", ",", "0", ",", "N2", ",", "0", ",", "0", ",", "N3", ",",
        "0", ",", "0", ",", "N4", ",", "0", ",", "0", ",", "N5", ",", "0", 
       ",", "0", ",", "N6", ",", "0", ",", "0", ",", "N7", ",", "0", ",", "0",
        ",", "N8", ",", "0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     "       ", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "N1", ",", "0", ",", "0", ",", "N2", ",", "0", ",", "0", ",", 
       "N3", ",", "0", ",", "0", ",", "N4", ",", "0", ",", "0", ",", "N5", 
       ",", "0", ",", "0", ",", "N6", ",", "0", ",", "0", ",", "N7", ",", "0",
        ",", "0", ",", "N8", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     "       ", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "N1", ",", "0", ",", "0", ",", "N2", ",", "0", ",", 
       "0", ",", "N3", ",", "0", ",", "0", ",", "N4", ",", "0", ",", "0", ",",
        "N5", ",", "0", ",", "0", ",", "N6", ",", "0", ",", "0", ",", "N7", 
       ",", "0", ",", "0", ",", "N8"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "Ni", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dk", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "1"}], "}"}]}], "]"}], "&"}], ",", 
       RowBox[{"0", " ", "&"}], ",", 
       RowBox[{"0", " ", "&"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0", "&"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "1"}], "}"}]}], "]"}], " ", "&"}], ",", 
       RowBox[{"0", " ", "&"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0", "&"}], ",", 
       RowBox[{"0", " ", "&"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"z", ",", "1"}], "}"}]}], "]"}], " ", "&"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "1"}], "}"}]}], "]"}], "&"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "1"}], "}"}]}], "]"}], "&"}], ",", 
       RowBox[{"0", "&"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0", "&"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"z", ",", "1"}], "}"}]}], "]"}], "&"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "1"}], "}"}]}], "]"}], "&"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"z", ",", "1"}], "}"}]}], "]"}], "&"}], ",", 
       RowBox[{"0", "&"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "1"}], "}"}]}], "]"}], "&"}]}], "}"}]}], "}"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLin", "=", 
   RowBox[{"Inner", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"#1", "[", "#2", "]"}], "&"}], ",", "Dk", ",", "Ni"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<dN1/dx = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"N1", ",", "x"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<dN1/dy = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"N1", ",", "y"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<dN1/dz = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"N1", ",", "z"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Bopsta = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "BLin", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["DelOpsta",
     FontSize->12], 
    StyleBox["=",
     FontSize->12], 
    RowBox[{
     StyleBox["{",
      FontSize->12], 
     RowBox[{
      StyleBox[
       RowBox[{"{", 
        RowBox[{"D11", ",", "D12", ",", "D13", ",", "0", ",", "0", ",", "0"}],
         "}"}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{"D21", ",", "D22", ",", "D23", ",", "0", ",", "0", ",", "0"}],
         "}"}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{"D31", ",", "D32", ",", "D33", ",", "0", ",", "0", ",", "0"}],
         "}"}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      RowBox[{
       StyleBox["{",
        FontSize->12], 
       RowBox[{
        StyleBox["0",
         FontSize->12], 
        StyleBox[",",
         FontSize->12], 
        StyleBox["0",
         FontSize->12], 
        StyleBox[",",
         FontSize->12], 
        StyleBox["0",
         FontSize->12], 
        StyleBox[",",
         FontSize->12], "D44", ",", "0", ",", "0"}], 
       StyleBox["}",
        FontSize->12]}], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "D55", ",", "0"}], 
        "}"}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "D66"}], 
        "}"}],
       FontSize->12]}], 
     StyleBox["}",
      FontSize->12]}]}], 
   StyleBox[";",
    FontSize->12]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", "Numerika", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Emodul", "=", "30000000"}], ";", 
  RowBox[{"\[Nu]\[Nu]", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aa", "=", "0.5"}], ";", 
  RowBox[{"bb", "=", "0.5"}], ";", 
  RowBox[{"cc", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinNumerika", "=", 
   RowBox[{"BLin", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<dN1/dx = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"N1", ",", "x"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "aa"}], ",", 
        RowBox[{"b", "\[Rule]", "bb"}], ",", 
        RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<dN1/dy = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"N1", ",", "y"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "aa"}], ",", 
        RowBox[{"b", "\[Rule]", "bb"}], ",", 
        RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<dN1/dz = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"N1", ",", "z"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "aa"}], ",", 
        RowBox[{"b", "\[Rule]", "bb"}], ",", 
        RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Bnumerika = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "BLinNumerika", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["Del",
    FontSize->12], 
   StyleBox["=",
    FontSize->12], 
   RowBox[{
    FractionBox["Em", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Nu]"}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", "*", "\[Nu]"}]}], ")"}]}]], 
    StyleBox["*",
     FontSize->12], 
    RowBox[{
     StyleBox["{",
      FontSize->12], 
     RowBox[{
      StyleBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "-", "\[Nu]"}], ",", "\[Nu]", ",", "\[Nu]", ",", "0", 
         ",", "0", ",", "0"}], "}"}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{"\[Nu]", ",", 
         RowBox[{"1", "-", "\[Nu]"}], ",", "\[Nu]", ",", "0", ",", "0", ",", 
         "0"}], "}"}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{"\[Nu]", ",", "\[Nu]", ",", 
         RowBox[{"1", "-", "\[Nu]"}], ",", "0", ",", "0", ",", "0"}], "}"}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      RowBox[{
       StyleBox["{",
        FontSize->12], 
       RowBox[{
        StyleBox["0",
         FontSize->12], 
        StyleBox[",",
         FontSize->12], 
        StyleBox["0",
         FontSize->12], 
        StyleBox[",",
         FontSize->12], 
        StyleBox["0",
         FontSize->12], 
        StyleBox[",",
         FontSize->12], 
        FractionBox[
         RowBox[{"1", "-", 
          RowBox[{"2", "*", "\[Nu]"}]}], "2"], ",", "0", ",", "0"}], 
       StyleBox["}",
        FontSize->12]}], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
         FractionBox[
          RowBox[{"1", "-", 
           RowBox[{"2", "*", "\[Nu]"}]}], "2"], ",", "0"}], "}"}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         FractionBox[
          RowBox[{"1", "-", 
           RowBox[{"2", "*", "\[Nu]"}]}], "2"]}], "}"}],
       FontSize->12]}], 
     StyleBox["}",
      FontSize->12]}]}]}], 
  StyleBox[";",
   FontSize->12]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DelNumerika", "=", 
   RowBox[{
    StyleBox["Del",
     FontSize->12], 
    StyleBox["/.",
     FontSize->12], 
    RowBox[{
     StyleBox["{",
      FontSize->12], 
     RowBox[{
      RowBox[{"Em", "\[Rule]", "Emodul"}], ",", 
      RowBox[{"\[Nu]", "\[Rule]", "\[Nu]\[Nu]"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<D = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"DelNumerika", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], "]"}], ",", 
    "\"\< * \!\(\*SuperscriptBox[\(10\), \(7\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BTDBNumerika", "=", 
   RowBox[{
    RowBox[{"Transpose", "[", "BLinNumerika", "]"}], ".", 
    StyleBox["DelNumerika",
     FontSize->12], 
    StyleBox[".",
     FontSize->12], 
    StyleBox["BLinNumerika",
     FontSize->12]}]}], 
  StyleBox[";",
   FontSize->12]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<\!\(\*SuperscriptBox[\(B\), \(T\)]\)DB = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", "BTDBNumerika", "]"}], "]"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"matricaKrutostiAnaliticki", "=", 
     RowBox[{"Integrate", "[", 
      RowBox[{"BTDBNumerika", 
       StyleBox[",",
        FontSize->12], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "aa"}], ",", "aa"}], "}"}],
        FontSize->12], 
       StyleBox[",",
        FontSize->12], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "bb"}], ",", "bb"}], "}"}],
        FontSize->12], 
       StyleBox[",",
        FontSize->12], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"z", ",", 
          RowBox[{"-", "cc"}], ",", "cc"}], "}"}],
        FontSize->12]}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<matricaKrutostiAnaliticki = \>\"", ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"Chop", "[", "matricaKrutostiNumerikaAnaliticki", "]"}], 
       "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"svojVrednostiMatricaKrutostiAnaliticki", "=", 
     RowBox[{"Eigenvalues", "[", "matricaKrutostiAnaliticki", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Svojstvene vrednosti matricaKrutostiAnaliticki = \>\"", ",", 
      RowBox[{"Chop", "[", 
       RowBox[{
       "MatrixForm", "[", "svojVrednostiMatricaKrutostiAnaliticki", "]"}], 
       "]"}]}], "]"}], ";"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N1PK", "=", 
   RowBox[{"N1", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
      RowBox[{
       FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
      RowBox[{
       FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N2PK", "=", 
   RowBox[{"N2", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
      RowBox[{
       FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
      RowBox[{
       FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N3PK", "=", 
   RowBox[{"N3", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
      RowBox[{
       FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
      RowBox[{
       FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N4PK", "=", 
   RowBox[{"N4", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
      RowBox[{
       FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
      RowBox[{
       FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N5PK", "=", 
   RowBox[{"N5", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
      RowBox[{
       FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
      RowBox[{
       FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N6PK", "=", 
   RowBox[{"N6", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
      RowBox[{
       FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
      RowBox[{
       FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N7PK", "=", 
   RowBox[{"N7", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
      RowBox[{
       FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
      RowBox[{
       FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N8PK", "=", 
   RowBox[{"N8", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
      RowBox[{
       FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
      RowBox[{
       FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 = \>\"", ",", "N1PK"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N2 = \>\"", ",", "N2PK"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N3 = \>\"", ",", "N3PK"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N4 = \>\"", ",", "N4PK"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N5 = \>\"", ",", "N5PK"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N6 = \>\"", ",", "N6PK"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N7 = \>\"", ",", "N7PK"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N8 = \>\"", ",", "N8PK"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dxPod\[Xi]", "=", "a"}], ";", 
  RowBox[{"dyPod\[Xi]", "=", "0"}], ";", 
  RowBox[{"dzPod\[Xi]", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dxPod\[Eta]", "=", "0"}], ";", 
  RowBox[{"dyPod\[Eta]", "=", "b"}], ";", 
  RowBox[{"dzPod\[Eta]", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dxPod\[Zeta]", "=", "0"}], ";", 
  RowBox[{"dyPod\[Zeta]", "=", "0"}], ";", 
  RowBox[{"dzPod\[Zeta]", "=", "c"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MJ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dxPod\[Xi]", ",", "dyPod\[Xi]", ",", "dzPod\[Xi]"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"dxPod\[Eta]", ",", "dyPod\[Eta]", ",", "dzPod\[Eta]"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"dxPod\[Zeta]", ",", "dyPod\[Zeta]", ",", "dzPod\[Zeta]"}], 
      "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "MJ", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detMJ", "=", 
   RowBox[{"Det", "[", "MJ", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<detJ = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "detMJ", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"invMJ", "=", 
   RowBox[{"Inverse", "[", "MJ", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<\!\(\*SuperscriptBox[\(J\), \(-1\)]\) = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "invMJ", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN1Pod\[Xi]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N1PK", ",", "\[Xi]"}], "]"}]}], ";", 
  RowBox[{"dN2Pod\[Xi]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N2PK", ",", "\[Xi]"}], "]"}]}], ";", 
  RowBox[{"dN3Pod\[Xi]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N3PK", ",", "\[Xi]"}], "]"}]}], ";", 
  RowBox[{"dN4Pod\[Xi]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N4PK", ",", "\[Xi]"}], "]"}]}], ";", 
  RowBox[{"dN5Pod\[Xi]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N5PK", ",", "\[Xi]"}], "]"}]}], ";", 
  RowBox[{"dN6Pod\[Xi]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N6PK", ",", "\[Xi]"}], "]"}]}], ";", 
  RowBox[{"dN7Pod\[Xi]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N7PK", ",", "\[Xi]"}], "]"}]}], ";", 
  RowBox[{"dN8Pod\[Xi]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N8PK", ",", "\[Xi]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN1Pod\[Eta]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N1PK", ",", "\[Eta]"}], "]"}]}], ";", 
  RowBox[{"dN2Pod\[Eta]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N2PK", ",", "\[Eta]"}], "]"}]}], ";", 
  RowBox[{"dN3Pod\[Eta]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N3PK", ",", "\[Eta]"}], "]"}]}], ";", 
  RowBox[{"dN4Pod\[Eta]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N4PK", ",", "\[Eta]"}], "]"}]}], ";", 
  RowBox[{"dN5Pod\[Eta]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N5PK", ",", "\[Eta]"}], "]"}]}], ";", 
  RowBox[{"dN6Pod\[Eta]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N6PK", ",", "\[Eta]"}], "]"}]}], ";", 
  RowBox[{"dN7Pod\[Eta]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N7PK", ",", "\[Eta]"}], "]"}]}], ";", 
  RowBox[{"dN8Pod\[Eta]", "=", 
   RowBox[{"D", "[", 
    RowBox[{"N8PK", ",", "\[Eta]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dN1Pod\[Zeta]", "=", 
    RowBox[{"D", "[", 
     RowBox[{"N1PK", ",", "\[Zeta]"}], "]"}]}], ";", 
   RowBox[{"dN2Pod\[Zeta]", "=", 
    RowBox[{"D", "[", 
     RowBox[{"N2PK", ",", "\[Zeta]"}], "]"}]}], ";", 
   RowBox[{"dN3Pod\[Zeta]", "=", 
    RowBox[{"D", "[", 
     RowBox[{"N3PK", ",", "\[Zeta]"}], "]"}]}], ";", 
   RowBox[{"dN4Pod\[Zeta]", "=", 
    RowBox[{"D", "[", 
     RowBox[{"N4PK", ",", "\[Zeta]"}], "]"}]}], ";", 
   RowBox[{"dN5Pod\[Zeta]", "=", 
    RowBox[{"D", "[", 
     RowBox[{"N5PK", ",", "\[Zeta]"}], "]"}]}], ";", 
   RowBox[{"dN6Pod\[Zeta]", "=", 
    RowBox[{"D", "[", 
     RowBox[{"N6PK", ",", "\[Zeta]"}], "]"}]}], ";", 
   RowBox[{"dN7Pod\[Zeta]", "=", 
    RowBox[{"D", "[", 
     RowBox[{"N7PK", ",", "\[Zeta]"}], "]"}]}], ";", 
   RowBox[{"dN8Pod\[Zeta]", "=", 
    RowBox[{"D", "[", 
     RowBox[{"N8PK", ",", "\[Zeta]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN1Podx", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN1Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN1Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN1Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN1Pody", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN1Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN1Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN1Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN1Podz", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN1Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN1Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN1Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN2Podx", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN2Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN2Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN2Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN2Pody", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN2Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN2Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN2Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN2Podz", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN2Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN2Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN2Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN3Podx", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN3Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN3Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN3Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN3Pody", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN3Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN3Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN3Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN3Podz", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN3Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN3Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN3Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN4Podx", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN4Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN4Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN4Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN4Pody", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN4Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN4Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN4Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN4Podz", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN4Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN4Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN4Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN5Podx", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN5Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN5Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN5Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN5Pody", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN5Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN5Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN5Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN5Podz", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN5Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN5Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN5Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN6Podx", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN6Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN6Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN6Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN6Pody", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN6Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN6Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN6Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN6Podz", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN6Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN6Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN6Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN7Podx", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN7Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN7Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN7Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN7Pody", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN7Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN7Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN7Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
  RowBox[{"dN7Podz", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"invMJ", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "All"}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "dN7Pod\[Xi]", "}"}], ",", 
        RowBox[{"{", "dN7Pod\[Eta]", "}"}], ",", 
        RowBox[{"{", "dN7Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dN8Podx", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"invMJ", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "All"}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "dN8Pod\[Xi]", "}"}], ",", 
         RowBox[{"{", "dN8Pod\[Eta]", "}"}], ",", 
         RowBox[{"{", "dN8Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
   RowBox[{"dN8Pody", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"invMJ", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "All"}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "dN8Pod\[Xi]", "}"}], ",", 
         RowBox[{"{", "dN8Pod\[Eta]", "}"}], ",", 
         RowBox[{"{", "dN8Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
   RowBox[{"dN8Podz", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"invMJ", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "All"}], "]"}], "]"}], ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "dN8Pod\[Xi]", "}"}], ",", 
         RowBox[{"{", "dN8Pod\[Eta]", "}"}], ",", 
         RowBox[{"{", "dN8Pod\[Zeta]", "}"}]}], "}"}]}], ")"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK", "=", 
   RowBox[{"(", GridBox[{
      {"dN1Podx", "0", "0", "dN2Podx", "0", "0", "dN3Podx", "0", "0", 
       "dN4Podx", "0", "0", "dN5Podx", "0", "0", "dN6Podx", "0", "0", 
       "dN7Podx", "0", "0", "dN8Podx", "0", "0"},
      {"0", "dN1Pody", "0", "0", "dN2Pody", "0", "0", "dN3Pody", "0", "0", 
       "dN4Pody", "0", "0", "dN5Pody", "0", "0", "dN6Pody", "0", "0", 
       "dN7Pody", "0", "0", "dN8Pody", "0"},
      {"0", "0", "dN1Podz", "0", "0", "dN2Podz", "0", "0", "dN3Podz", "0", 
       "0", "dN4Podz", "0", "0", "dN5Podz", "0", "0", "dN6Podz", "0", "0", 
       "dN7Podz", "0", "0", "dN8Podz"},
      {"dN1Pody", "dN1Podx", "0", "dN2Pody", "dN2Podx", "0", "dN3Pody", 
       "dN3Podx", "0", "dN4Pody", "dN4Podx", "0", "dN5Pody", "dN5Podx", "0", 
       "dN6Pody", "dN6Podx", "0", "dN7Pody", "dN7Podx", "0", "dN8Pody", 
       "dN8Podx", "0"},
      {"0", "dN1Podz", "dN1Pody", "0", "dN2Podz", "dN2Pody", "0", "dN3Podz", 
       "dN3Pody", "0", "dN4Podz", "dN4Pody", "0", "dN5Podz", "dN5Pody", "0", 
       "dN6Podz", "dN6Pody", "0", "dN7Podz", "dN7Pody", "0", "dN8Podz", 
       "dN8Pody"},
      {"dN1Podz", "0", "dN1Podx", "dN2Podz", "0", "dN2Podx", "dN3Podz", "0", 
       "dN3Podx", "dN4Podz", "0", "dN4Podx", "dN5Podz", "0", "dN5Podx", 
       "dN6Podz", "0", "dN6Podx", "dN7Podz", "0", "dN7Podx", "dN8Podz", "0", 
       "dN8Podx"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<B = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "BLinPK", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Kontrola BLin - BLinPK\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"BLin", "//.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox["x", "a"], "\[Rule]", "\[Xi]"}], ",", 
            RowBox[{
             FractionBox["y", "b"], "\[Rule]", "\[Eta]"}], ",", 
            RowBox[{
             FractionBox["z", "c"], "\[Rule]", "\[Zeta]"}]}], " ", "}"}]}], 
         ")"}], "-", "BLinPK"}], "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"detMJNumerika", "=", 
    RowBox[{"detMJ", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "\[Rule]", "aa"}], ",", 
       RowBox[{"b", "\[Rule]", "bb"}], ",", 
       RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Red", " ", "integracije", " ", "2", "x2x2"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK1tackaNI2GT", "=", 
   RowBox[{"BLinPK", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK2tackaNI2GT", "=", 
   RowBox[{"BLinPK", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK3tackaNI2GT", "=", 
   RowBox[{"BLinPK", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK4tackaNI2GT", "=", 
   RowBox[{"BLinPK", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK5tackaNI2GT", "=", 
   RowBox[{"BLinPK", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK6tackaNI2GT", "=", 
   RowBox[{"BLinPK", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK7tackaNI2GT", "=", 
   RowBox[{"BLinPK", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BLinPK8tackaNI2GT", "=", 
   RowBox[{"BLinPK", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "1"}], "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Eta]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"\[Zeta]", "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ",", 
      RowBox[{"a", "\[Rule]", "aa"}], ",", 
      RowBox[{"b", "\[Rule]", "bb"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MKNI2GT", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", "BLinPK1tackaNI2GT", "]"}], ".", 
         "DelNumerika", ".", "BLinPK1tackaNI2GT"}], "*", "1", "*", "1", "*", 
        "1"}], "+", "\[IndentingNewLine]", "             ", 
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", " ", "BLinPK2tackaNI2GT", "]"}], ".", 
         "DelNumerika", ".", "BLinPK2tackaNI2GT"}], "*", "1", "*", "1", "*", 
        "1"}], "+", "\[IndentingNewLine]", "             ", 
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", "BLinPK3tackaNI2GT", "]"}], ".", 
         "DelNumerika", ".", "BLinPK3tackaNI2GT"}], "*", "1", "*", "1", "*", 
        "1"}], "+", "\[IndentingNewLine]", "             ", 
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", " ", "BLinPK4tackaNI2GT", "]"}], ".", 
         "DelNumerika", ".", "BLinPK4tackaNI2GT"}], "*", "1", "*", "1", "*", 
        "1"}], "+", "\[IndentingNewLine]", "             ", 
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", " ", "BLinPK5tackaNI2GT", "]"}], ".", 
         "DelNumerika", ".", "BLinPK5tackaNI2GT"}], "*", "1", "*", "1", "*", 
        "1"}], "+", "\[IndentingNewLine]", "            ", 
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", "BLinPK6tackaNI2GT", "]"}], ".", 
         "DelNumerika", ".", "BLinPK6tackaNI2GT"}], "*", "1", "*", "1", "*", 
        "1"}], "+", "\[IndentingNewLine]", "            ", 
       RowBox[{
        RowBox[{
         RowBox[{"Transpose", "[", " ", "BLinPK7tackaNI2GT", "]"}], ".", 
         "DelNumerika", ".", "BLinPK7tackaNI2GT"}], "*", "1", "*", "1", "*", 
        "1"}], "+", "\[IndentingNewLine]", "            ", 
       RowBox[{
        RowBox[{"Transpose", "[", "BLinPK8tackaNI2GT", "]"}], ".", 
        "DelNumerika", ".", "BLinPK8tackaNI2GT"}]}], ")"}], "*", 
     "detMJNumerika"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<MKNI2GT = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"MKNI2GT", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}], "]"}], ",", 
    "\"\< * \!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"svojVrednostiMKNI2GT", "=", 
   RowBox[{"Eigenvalues", "[", "MKNI2GT", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Svojstvene vrednosti MKNI2GT = \>\"", ",", 
     RowBox[{"Chop", "[", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"svojVrednostiMKNI2GT", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "7"}]]}], "]"}], "]"}], ",", 
     "\"\< * \!\(\*SuperscriptBox[\(10\), \(7\)]\)\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Kontrola = matricaKrutostiAnaliticki - MKNI2GT = \>\"", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"Chop", "[", 
        RowBox[{"matricaKrutostiAnaliticki", "-", "MKNI2GT"}], "]"}], "]"}]}],
      "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Kontrola = matricaKrutostiAnaliticki - MKNI2GT = \>\"", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"Chop", "[", 
        RowBox[{
        "svojVrednostiMatricaKrutostiAnaliticki", "-", 
         "svojVrednostiMKNI2GT"}], "]"}], "]"}]}], "]"}], ";"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Vektor", " ", "ekvivalentnog", " ", "opterecenja"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qbz", "=", 
   RowBox[{"-", "10000"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qb", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", "qbz", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ns", "=", 
   RowBox[{"Ni", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"N1", "\[Rule]", "0"}], ",", 
      RowBox[{"N2", "\[Rule]", "0"}], ",", 
      RowBox[{"N3", "\[Rule]", "0"}], ",", 
      RowBox[{"N4", "\[Rule]", "0"}], ",", 
      RowBox[{"z", "\[Rule]", "cc"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Ns = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "Ns", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Ns = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Ns", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", "aa"}], ",", 
        RowBox[{"b", "\[Rule]", "bb"}]}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"IntegrandQ", "=", 
   RowBox[{
    RowBox[{"Transpose", "[", "Ns", "]"}], ".", "qb"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<IntegrandQ = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "IntegrandQ", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Transpose", "[", "Ns", "]"}], ".", "qb"}], ")"}], ",", 
     RowBox[{"{", 
      StyleBox[
       RowBox[{"x", ",", 
        RowBox[{"-", "aa"}], ",", "aa"}],
       FontSize->12], 
      StyleBox["}",
       FontSize->12]}], 
     StyleBox[",",
      FontSize->12], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "bb"}], ",", "bb"}], "}"}],
      FontSize->12]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Q = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "Q", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nss", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"N5", ",", "N6", ",", "N7", ",", "N8"}], "}"}], "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"z", "\[Rule]", "cc"}], ",", 
      RowBox[{"c", "\[Rule]", "cc"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Nss = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "Nss", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Q drugi nacin = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"Nss", "*", "qbz"}], ",", 
        RowBox[{"{", 
         StyleBox[
          RowBox[{"x", ",", 
           RowBox[{"-", "aa"}], ",", "aa"}],
          FontSize->12], 
         StyleBox["}",
          FontSize->12]}], 
        StyleBox[",",
         FontSize->12], 
        StyleBox[
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"-", "bb"}], ",", "bb"}], "}"}],
         FontSize->12]}], 
       StyleBox["]",
        FontSize->12]}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NsPK", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"N5PK", ",", "N6PK", ",", "N7PK", ",", "N8PK"}], "}"}], "}"}], "//.", 
    RowBox[{"{", 
     RowBox[{"\[Zeta]", "\[Rule]", "1"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<NsPK = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "NsPK", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJOptPovrsine", "=", 
   RowBox[{"aa", "*", "bb"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qbPk", "=", "qbz"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QPK", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "NsPK", "]"}], "*", "qbPk", "*", 
      "detJOptPovrsine"}], ",", 
     RowBox[{"{", 
      StyleBox[
       RowBox[{"\[Xi]", ",", 
        RowBox[{"-", "1"}], ",", "1"}],
       FontSize->12], 
      StyleBox["}",
       FontSize->12]}], 
     StyleBox[",",
      FontSize->12], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}],
      FontSize->12]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<QPK = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "QPK", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Kaa", "=", 
   RowBox[{"MKNI2GT", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"13", ";;", "24"}], ",", 
      RowBox[{"13", ";;", "24"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Kaa = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Kaa", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}], "]"}], ",", 
    "\"\< * \!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Sa", "=", 
   RowBox[{"Q", "[", 
    RowBox[{"[", 
     RowBox[{"13", ";;", "24"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Sa = \>\"", ",", 
    RowBox[{"MatrixForm", "[", "Sa", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"da", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "Kaa", "]"}], ".", "Sa"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<da = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"da", "*", 
      SuperscriptBox["10", "3"]}], "]"}], ",", 
    "\"\< * \!\(\*SuperscriptBox[\(10\), \(-3\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Exit", "[", "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.671285218561768*^9, 3.6712852224778795`*^9}, {
   3.6712853507781982`*^9, 3.6712853533627048`*^9}, {3.6712855156956444`*^9, 
   3.6712856569865522`*^9}, {3.67128569827171*^9, 3.6712858122335777`*^9}, {
   3.671285854529786*^9, 3.6712859397580795`*^9}, 3.671286029911565*^9, {
   3.67128621048756*^9, 3.671286417539914*^9}, {3.671286456937516*^9, 
   3.671286511641947*^9}, {3.6712865498084764`*^9, 3.671286641308779*^9}, {
   3.671286679408077*^9, 3.671286680392885*^9}, {3.6712868347312326`*^9, 
   3.6712870316508045`*^9}, {3.6712870631202908`*^9, 3.671287172719783*^9}, {
   3.671287218035914*^9, 3.6712872453120375`*^9}, {3.6712872857306986`*^9, 
   3.671287480913745*^9}, {3.67128760822691*^9, 3.671287615294515*^9}, {
   3.671287658983341*^9, 3.671287664085622*^9}, {3.671287720015352*^9, 
   3.6712878112462034`*^9}, {3.6712878430778933`*^9, 3.671288010857177*^9}, {
   3.6712880484430227`*^9, 3.6712880832353263`*^9}, {3.6712881190409427`*^9, 
   3.6712882842351017`*^9}, {3.671288322262892*^9, 3.6712886145514774`*^9}, {
   3.6712886499296465`*^9, 3.6712886964168*^9}, {3.6712887356531954`*^9, 
   3.6712887796809597`*^9}, {3.671288846683859*^9, 3.6712888540468025`*^9}, {
   3.671289010278998*^9, 3.6712890786229305`*^9}, {3.671289116596269*^9, 
   3.671289336057767*^9}, {3.6712893733520656`*^9, 3.6712894058850164`*^9}, {
   3.671289450951722*^9, 3.671289516751732*^9}, {3.6712895713626103`*^9, 
   3.6712897779221067`*^9}, {3.6712898803641434`*^9, 
   3.6712899069621696`*^9}, {3.6712900872947817`*^9, 3.671290110523388*^9}, {
   3.671290142906954*^9, 3.671290242433835*^9}, {3.6712907191559258`*^9, 
   3.6712907227028365`*^9}, {3.6712915529308906`*^9, 
   3.6712915541158876`*^9}, {3.6712915849831967`*^9, 
   3.6712915884658127`*^9}, {3.6712918668742604`*^9, 
   3.6712918948896437`*^9}, {3.6713638866615114`*^9, 
   3.6713639267959366`*^9}, {3.6713639654021297`*^9, 3.671364108649173*^9}, {
   3.671364163210293*^9, 3.671364170181383*^9}, 3.6713642026152887`*^9, 
   3.6713642576706853`*^9, {3.6713643072988725`*^9, 3.671364539558816*^9}, {
   3.671364580433095*^9, 3.6713645989780054`*^9}, {3.6713647080053787`*^9, 
   3.6713647472653875`*^9}, {3.6713647778689423`*^9, 3.6713647784323025`*^9}, 
   3.6713648706601353`*^9, {3.6713649157743363`*^9, 3.671364916136832*^9}, {
   3.6713649473896675`*^9, 3.671364998649497*^9}, {3.6713650955230904`*^9, 
   3.6713651050399957`*^9}, {3.671365304869897*^9, 3.6713653248734503`*^9}, {
   3.671365354956499*^9, 3.6713653614089217`*^9}, {3.671365396020467*^9, 
   3.671365431412361*^9}, {3.6713654780513506`*^9, 3.671365521483403*^9}, {
   3.6713656732056217`*^9, 3.6713659212539225`*^9}, {3.671426518830373*^9, 
   3.671426525233269*^9}, {3.6717741921281157`*^9, 3.671774212176962*^9}, {
   3.6717789587768874`*^9, 3.671779013165189*^9}, {3.6717791379871535`*^9, 
   3.671779186932439*^9}, {3.6717792438884296`*^9, 3.6717793035061707`*^9}, {
   3.671779347320695*^9, 3.671779450410405*^9}, {3.6717794989769335`*^9, 
   3.671779604387034*^9}, {3.671779661628614*^9, 3.671779707251586*^9}, {
   3.671779778085601*^9, 3.6717797983356867`*^9}, {3.6717799029052763`*^9, 
   3.6717799639934483`*^9}, {3.671780311972494*^9, 3.67178040856621*^9}, {
   3.671780639584324*^9, 3.6717807654167814`*^9}, {3.671780807517355*^9, 
   3.6717810976553736`*^9}, {3.6717811317585583`*^9, 3.671781206914386*^9}, {
   3.671781307239745*^9, 3.6717815025710073`*^9}, {3.671811932819356*^9, 
   3.6718122482552824`*^9}, {3.671812290688249*^9, 3.6718123623678527`*^9}, {
   3.671812420006447*^9, 3.671812446252369*^9}, {3.6718124774740324`*^9, 
   3.6718127818101397`*^9}, {3.6718128374554253`*^9, 3.67181294308043*^9}, {
   3.6718129769926376`*^9, 3.671813025462169*^9}, {3.6718130554713297`*^9, 
   3.6718132072752457`*^9}, {3.6718132726530647`*^9, 
   3.6718133742146673`*^9}, {3.6718134566132936`*^9, 3.671813580997898*^9}, {
   3.6718136154354467`*^9, 3.671813693988187*^9}, {3.671813739948841*^9, 
   3.671813787935314*^9}, {3.671813823417328*^9, 3.6718138250337043`*^9}, {
   3.6718138586745963`*^9, 3.671813895540545*^9}, {3.671814004842018*^9, 
   3.671814015478223*^9}, {3.6718199742193604`*^9, 3.6718200065635724`*^9}, {
   3.671820129618413*^9, 3.671820269119842*^9}, {3.671820338812415*^9, 
   3.6718203547218266`*^9}, {3.6718204023935676`*^9, 3.671820483971063*^9}, {
   3.671820584744954*^9, 3.6718206394933834`*^9}, {3.6718206805555696`*^9, 
   3.671820815156568*^9}, {3.6718208744598036`*^9, 3.6718209332828016`*^9}, {
   3.6718209668721514`*^9, 3.671820989211153*^9}, {3.671821061964681*^9, 
   3.671821111418125*^9}, {3.6718211845255175`*^9, 3.671821206509573*^9}, {
   3.6718212509793873`*^9, 3.6718215076635666`*^9}, {3.6718215393771024`*^9, 
   3.671821600321368*^9}, {3.6718216533057375`*^9, 3.671821663539055*^9}, {
   3.6718217255988903`*^9, 3.6718217759507914`*^9}, {3.6718218311602097`*^9, 
   3.6718218478347163`*^9}, {3.671821894305772*^9, 3.6718219297300587`*^9}, {
   3.6718221910898223`*^9, 3.6718222901567526`*^9}, {3.6718223518925424`*^9, 
   3.6718225175328913`*^9}, 3.671822579147814*^9, {3.67182269184648*^9, 
   3.6718228493494787`*^9}, {3.6718229830961466`*^9, 
   3.6718229872818766`*^9}, {3.6718230654528136`*^9, 3.671823141868691*^9}, {
   3.67182320143335*^9, 3.671823240288227*^9}, {3.6718232919420924`*^9, 
   3.671823308103662*^9}, {3.6718234025042424`*^9, 3.671823424530915*^9}, {
   3.6718236946353188`*^9, 3.6718237445504704`*^9}, {3.6718237783912354`*^9, 
   3.67182381086469*^9}, {3.6718239024213147`*^9, 3.6718239490975456`*^9}, {
   3.6718239959855213`*^9, 3.671824016390843*^9}, {3.6718240594319086`*^9, 
   3.671824124689901*^9}, {3.671824195488669*^9, 3.6718242009410715`*^9}, {
   3.6718242333409853`*^9, 3.671824252207259*^9}, {3.6718551784605937`*^9, 
   3.6718553262731314`*^9}, {3.6718553762594056`*^9, 
   3.6718554381127787`*^9}, {3.6718554853514585`*^9, 
   3.6718555283276367`*^9}, {3.671855593829836*^9, 3.671855603579984*^9}, {
   3.671855715187302*^9, 3.6718557398636*^9}, {3.6718557699019794`*^9, 
   3.6718557714182944`*^9}, {3.671855809941201*^9, 3.671855840050542*^9}, {
   3.6718559442812276`*^9, 3.6718559572800417`*^9}, {3.671856009468233*^9, 
   3.6718560570520725`*^9}, {3.671856101122105*^9, 3.6718561195348864`*^9}, {
   3.6718561626039658`*^9, 3.671856214746307*^9}, {3.671856272127247*^9, 
   3.6718562967772355`*^9}, 3.6718563310219126`*^9, {3.671856365488142*^9, 
   3.6718564155486126`*^9}, {3.671856458084223*^9, 3.671856474950062*^9}, {
   3.6718565060179415`*^9, 3.6718565467233124`*^9}, {3.671856613116184*^9, 
   3.671856653242087*^9}, {3.6718567121782827`*^9, 3.671856741618887*^9}, {
   3.6718567808982434`*^9, 3.6718569254495945`*^9}, {3.6718570757330837`*^9, 
   3.6718570855854588`*^9}, {3.6718571496350346`*^9, 
   3.6718571772586803`*^9}, {3.6718572291595306`*^9, 
   3.6718573207738256`*^9}, {3.6718574423460197`*^9, 3.671857466454465*^9}, {
   3.67185749711569*^9, 3.671857606936226*^9}, {3.671857655201708*^9, 
   3.671857686448434*^9}, {3.671857846702374*^9, 3.671857853955722*^9}, {
   3.67185788974846*^9, 3.671857900011544*^9}, {3.6718580239176764`*^9, 
   3.6718580246959057`*^9}, {3.671860089122366*^9, 3.671860175990391*^9}, {
   3.6718602160513296`*^9, 3.6718603397783556`*^9}, {3.6718604664273148`*^9, 
   3.6718605111823053`*^9}, {3.6718605670257945`*^9, 
   3.6718606463989315`*^9}, {3.6718606832246585`*^9, 3.6718606992270565`*^9}, 
   3.6718609088190937`*^9, {3.671860998007786*^9, 3.671861005307844*^9}, {
   3.6718617100985355`*^9, 3.671861714417272*^9}, {3.6718942709914985`*^9, 
   3.671894335625294*^9}, {3.6718949699354415`*^9, 3.671894970088913*^9}, {
   3.6718987476369715`*^9, 3.6718987483997793`*^9}, 3.6718989474868484`*^9, {
   3.671902181506486*^9, 3.6719022068810854`*^9}, {3.6719028263980923`*^9, 
   3.671902854322629*^9}, 3.6719521015513687`*^9, {3.6719830084599595`*^9, 
   3.671983021329599*^9}, {3.764850539337758*^9, 3.76485054025616*^9}, {
   3.764850635119614*^9, 3.7648507116432886`*^9}, 3.7648507719598923`*^9, 
   3.764850839990103*^9, {3.7648512978726315`*^9, 3.764851298837706*^9}, 
   3.764851811456026*^9, {3.7648525225664234`*^9, 3.7648526225140066`*^9}, {
   3.764852657875308*^9, 3.7648526590160475`*^9}, {3.7648527384406643`*^9, 
   3.7648527831957755`*^9}, {3.7648528351164117`*^9, 
   3.7648532582045083`*^9}, {3.764853356762643*^9, 3.7648534199999313`*^9}, {
   3.7648534522893753`*^9, 3.764853459246668*^9}, {3.764853492254261*^9, 
   3.764853543273456*^9}, {3.764853599536957*^9, 3.764853607188237*^9}, {
   3.76485376817686*^9, 3.7648538015875854`*^9}, {3.764853835567177*^9, 
   3.764853915326338*^9}, {3.7648539702145042`*^9, 3.764853971618474*^9}, {
   3.7648540847665024`*^9, 3.7648540857002497`*^9}, {3.7648542209112463`*^9, 
   3.7648542371406193`*^9}, {3.764854274005555*^9, 3.7648542931432734`*^9}, {
   3.764854323581976*^9, 3.764854444811792*^9}, 3.764854562667125*^9, 
   3.7648546292653484`*^9, {3.7648548581264105`*^9, 3.7648548601479225`*^9}, {
   3.7657752466623774`*^9, 3.7657752473325505`*^9}, {3.7658813395916853`*^9, 
   3.765881448289203*^9}, {3.765881488813991*^9, 3.765881556276971*^9}, {
   3.765882163004282*^9, 3.7658821652098007`*^9}, {3.7658823357784305`*^9, 
   3.765882406763747*^9}, {3.765882497851982*^9, 3.765882685234913*^9}, {
   3.7659513069574285`*^9, 3.7659513076216183`*^9}, 3.7659515949117403`*^9, {
   3.7686433368596773`*^9, 3.768643345823449*^9}, {3.7888683350258455`*^9, 
   3.788868375576277*^9}, {3.78886841172418*^9, 3.788868427260683*^9}, {
   3.7888691907912993`*^9, 3.7888692010860343`*^9}, {3.788869835867634*^9, 
   3.7888698712882147`*^9}, {3.7888712404301295`*^9, 
   3.7888713105880127`*^9}, {3.7888713832481165`*^9, 
   3.7888714096363935`*^9}, {3.788871445963838*^9, 3.788871454895713*^9}, {
   3.788875011781168*^9, 3.7888750166433363`*^9}, {3.788875091226059*^9, 
   3.7888753903779535`*^9}, {3.788875424680818*^9, 3.788875458243658*^9}, {
   3.788875549741234*^9, 3.7888755925845265`*^9}, {3.7888756459069138`*^9, 
   3.788875648762*^9}, {3.7888757070779734`*^9, 3.7888757421371164`*^9}, {
   3.788875803540922*^9, 3.788875855002714*^9}, {3.7888759030099225`*^9, 
   3.7888759293119535`*^9}, {3.7888759694250717`*^9, 
   3.7888759818829727`*^9}, {3.788876033942625*^9, 3.7888760342602825`*^9}, {
   3.788876092120573*^9, 3.78887613288743*^9}, {3.788876175376999*^9, 
   3.78887625555857*^9}, 3.7888763669045854`*^9, {3.7888764125905514`*^9, 
   3.788876821599981*^9}, {3.7888768539380307`*^9, 3.788876937039981*^9}, {
   3.788876978329454*^9, 3.7888769976538086`*^9}, {3.78887703002542*^9, 
   3.7888772036665*^9}, {3.7888772573958917`*^9, 3.7888774867392893`*^9}, {
   3.788878060292031*^9, 3.7888780849149446`*^9}, {3.788878116869171*^9, 
   3.7888782320923886`*^9}, {3.788878266245311*^9, 3.7888784384288692`*^9}, {
   3.78887849478141*^9, 3.7888785117391*^9}, {3.788878600777542*^9, 
   3.7888787355454855`*^9}, {3.788878805788706*^9, 3.7888788594279146`*^9}, {
   3.788878937411618*^9, 3.788878993699915*^9}, {3.788879044385849*^9, 
   3.7888790570286493`*^9}, {3.7889277027066326`*^9, 3.78892774620237*^9}, {
   3.7889280701483192`*^9, 3.788928141080653*^9}, {3.7889281827532663`*^9, 
   3.788928193720052*^9}, {3.78892826653611*^9, 3.7889283048322763`*^9}, {
   3.7889284990179915`*^9, 3.7889284995061855`*^9}, {3.788928586159482*^9, 
   3.788928624278353*^9}, {3.78892865966041*^9, 3.78892871630365*^9}, {
   3.788929867846249*^9, 3.7889298684112325`*^9}, {3.788930262719632*^9, 
   3.7889305267227263`*^9}, {3.7889306147870703`*^9, 
   3.7889306604723024`*^9}, {3.7889307132712784`*^9, 3.788930756268108*^9}, {
   3.7889307903948064`*^9, 3.7889307939007564`*^9}, {3.7889308523866963`*^9, 
   3.7889309434564586`*^9}, {3.788931030425323*^9, 3.788931162231959*^9}, {
   3.7889312823834467`*^9, 3.7889312840554113`*^9}, {3.788931315585106*^9, 
   3.7889314880972548`*^9}, {3.7889315182746763`*^9, 3.788931626692915*^9}, {
   3.7889316638505125`*^9, 3.788931695556734*^9}, {3.788931750353458*^9, 
   3.7889317937618065`*^9}, {3.7889318657636456`*^9, 3.788932122897314*^9}, {
   3.788932208111255*^9, 3.7889322593392577`*^9}, {3.7889323170669365`*^9, 
   3.788932346935416*^9}, {3.7889324258400745`*^9, 3.788932427028426*^9}, {
   3.7889325116645536`*^9, 3.7889325652719326`*^9}, {3.788932601249574*^9, 
   3.7889326295904965`*^9}, 3.788932663515993*^9, {3.7889327225289545`*^9, 
   3.7889327371778603`*^9}, {3.7889327728234186`*^9, 
   3.7889327908741307`*^9}, {3.7889328826694326`*^9, 
   3.7889329132232895`*^9}, {3.7889330725275407`*^9, 
   3.7889330731056595`*^9}, {3.7889331032253304`*^9, 
   3.7889331051471972`*^9}, {3.7889336873689585`*^9, 3.788933860702362*^9}, {
   3.7889339034640613`*^9, 3.788934030376363*^9}, {3.7889340697034044`*^9, 
   3.7889341099545465`*^9}, {3.788934149700876*^9, 3.7889342132389355`*^9}, {
   3.788934264848363*^9, 3.7889342830738583`*^9}, {3.7889343132574725`*^9, 
   3.788934614429613*^9}, {3.788934663501567*^9, 3.788934686694477*^9}, {
   3.7889347411103125`*^9, 3.7889347925621305`*^9}, 3.7889348356393414`*^9, {
   3.788934880140425*^9, 3.7889348938515415`*^9}, {3.788934939486585*^9, 
   3.788935082930088*^9}, {3.7889351211501803`*^9, 3.7889351408905783`*^9}, 
   3.7889351741547246`*^9, {3.788935252884767*^9, 3.788935342188068*^9}, {
   3.7889354425502276`*^9, 3.788935490909715*^9}, {3.788935546590757*^9, 
   3.788935598585597*^9}, {3.788935745258687*^9, 3.7889358353096666`*^9}, {
   3.7889358756468916`*^9, 3.788935941789583*^9}, {3.788935973524351*^9, 
   3.7889360682046227`*^9}, {3.7889360994055986`*^9, 
   3.7889361965614214`*^9}, {3.788936229416624*^9, 3.788936281779401*^9}, {
   3.7889363167117624`*^9, 3.78893631727426*^9}, {3.788936350325221*^9, 
   3.7889363547881804`*^9}, 3.7889364043104343`*^9, {3.788936468283768*^9, 
   3.788936472783749*^9}, {3.788936550841318*^9, 3.7889365917246265`*^9}, {
   3.788936624923196*^9, 3.7889366623949423`*^9}, {3.788936713039298*^9, 
   3.7889367238542137`*^9}, 3.7889368492799854`*^9, {3.7889369499518933`*^9, 
   3.7889369500925183`*^9}, {3.788936983017535*^9, 3.7889370718366346`*^9}, {
   3.7889371058205967`*^9, 3.788937109070583*^9}, 3.7889372314799876`*^9, {
   3.7889373144715014`*^9, 3.7889374040086536`*^9}, {3.7889374377889977`*^9, 
   3.7889375105223885`*^9}, {3.7889375755687256`*^9, 
   3.7889376237265973`*^9}, {3.788937697449001*^9, 3.7889377313929405`*^9}, {
   3.788937814713395*^9, 3.7889378496023054`*^9}, {3.788937916908702*^9, 
   3.78893794647971*^9}, {3.7889379933369236`*^9, 3.7889380774623194`*^9}, {
   3.7889385634986362`*^9, 3.788938584419098*^9}, {3.788938642662367*^9, 
   3.7889387175439806`*^9}, {3.78893875173489*^9, 3.788938823010933*^9}, 
   3.788938853674123*^9, {3.7889388881523705`*^9, 3.7889389207902775`*^9}, {
   3.788938994410183*^9, 3.788939000930122*^9}, {3.7889390906451716`*^9, 
   3.788939103344173*^9}, {3.7889391357277517`*^9, 3.788939246151387*^9}, {
   3.7889393046677485`*^9, 3.7889393764003906`*^9}, {3.7889394113789015`*^9, 
   3.788939457843468*^9}, {3.7889395135611067`*^9, 3.7889397004651575`*^9}, {
   3.788939750862116*^9, 3.788939867939757*^9}, {3.788939905089368*^9, 
   3.7889399744039097`*^9}, {3.7889400251977015`*^9, 3.788940088711226*^9}, {
   3.7889401356048317`*^9, 3.7889401596426983`*^9}, {3.788940221678084*^9, 
   3.7889402299874115`*^9}, {3.788940266193453*^9, 3.788940266740344*^9}, {
   3.788940460823142*^9, 3.7889405816799746`*^9}, {3.7889406123770475`*^9, 
   3.7889408309900866`*^9}, {3.788940874956951*^9, 3.7889409673805532`*^9}, {
   3.7889410318378477`*^9, 3.788941047106982*^9}, {3.7889410866515417`*^9, 
   3.788941106266632*^9}, {3.7889411702337947`*^9, 3.7889412104324627`*^9}, {
   3.788941249957552*^9, 3.78894128222021*^9}, {3.788941320337202*^9, 
   3.788941416522251*^9}, {3.788941490738638*^9, 3.7889414908306336`*^9}, {
   3.7889415298528266`*^9, 3.788941678410945*^9}, {3.7889417129325294`*^9, 
   3.788941788358096*^9}, {3.7889418468701725`*^9, 3.788941855901862*^9}, {
   3.7889420651805534`*^9, 3.7889421161174326`*^9}, {3.7889421474732027`*^9, 
   3.7889422577717943`*^9}, {3.788942303617524*^9, 3.7889424714791937`*^9}, {
   3.788942519320487*^9, 3.788942594647809*^9}, {3.7889426356570315`*^9, 
   3.7889426692096815`*^9}, {3.788942703217082*^9, 3.78894270651571*^9}, {
   3.788942754963399*^9, 3.788942788869017*^9}, {3.7889428225684185`*^9, 
   3.7889430646928864`*^9}, {3.788943292588423*^9, 3.7889433432983217`*^9}, {
   3.7889448499168944`*^9, 3.7889448985276546`*^9}, {3.788944936174612*^9, 
   3.788944945156077*^9}, {3.7889449772776623`*^9, 3.7889450176829185`*^9}, {
   3.7889450663171453`*^9, 3.7889452744140944`*^9}, {3.7889453132757463`*^9, 
   3.7889455905750628`*^9}, {3.7889456691017303`*^9, 3.788945744113161*^9}, {
   3.7889458012545357`*^9, 3.788945850892818*^9}, {3.7889459012495317`*^9, 
   3.7889460897136855`*^9}, {3.7889461526720867`*^9, 3.788946265544243*^9}, {
   3.788946305278676*^9, 3.788946330675517*^9}, {3.7889463633885746`*^9, 
   3.7889464337150946`*^9}, {3.788946500555638*^9, 3.788946551090985*^9}, {
   3.788946607516986*^9, 3.7889467505657225`*^9}, 3.7889467892684407`*^9, {
   3.7889468444326906`*^9, 3.7889468456202016`*^9}, 3.788946879327982*^9, {
   3.788946967481017*^9, 3.7889471081995664`*^9}, {3.788947211933799*^9, 
   3.788947344984446*^9}, {3.7889473811507883`*^9, 3.7889474765330505`*^9}, {
   3.788947545103493*^9, 3.788947548684409*^9}, {3.789023061008133*^9, 
   3.7890232181868067`*^9}, {3.789023349713216*^9, 3.7890234902202873`*^9}, {
   3.7890235513195314`*^9, 3.7890235609296155`*^9}, {3.7890236002351155`*^9, 
   3.7890236611514444`*^9}, {3.7890238415336933`*^9, 3.789023864943338*^9}, {
   3.789023910818262*^9, 3.7890239198446064`*^9}, 3.7890241520480905`*^9, {
   3.7890241937357283`*^9, 3.789024335991862*^9}, {3.7890243854397326`*^9, 
   3.789024437110846*^9}, {3.7890245319719687`*^9, 3.7890245528745394`*^9}, {
   3.789024651954897*^9, 3.7890246989480934`*^9}, {3.7890247681577177`*^9, 
   3.789024780584651*^9}, {3.789024819295697*^9, 3.789024841085168*^9}, {
   3.789024876726943*^9, 3.789025071435512*^9}, {3.789025109168145*^9, 
   3.78902521049349*^9}, {3.789025326046049*^9, 3.7890253613823905`*^9}, {
   3.7890253995219755`*^9, 3.789025473728295*^9}, {3.789025509692209*^9, 
   3.789025560624873*^9}, {3.7890256437284265`*^9, 3.7890256442987905`*^9}, {
   3.789025699377643*^9, 3.7890257192177715`*^9}, 3.7890257537080913`*^9, {
   3.789025829125077*^9, 3.7890258334942102`*^9}, {3.7890260353542414`*^9, 
   3.7890260913879347`*^9}, {3.789026122237811*^9, 3.789026184378585*^9}, {
   3.789026236255331*^9, 3.789026296185978*^9}, {3.789026348791497*^9, 
   3.789026350982068*^9}, {3.789026388246945*^9, 3.7890263937229595`*^9}, {
   3.789026503954151*^9, 3.7890265773010025`*^9}, {3.789026610673023*^9, 
   3.7890266517928057`*^9}, {3.789026682706566*^9, 3.7890266929331837`*^9}, {
   3.7890267361999865`*^9, 3.7890267750484004`*^9}, {3.789026809354734*^9, 
   3.7890268472747054`*^9}, 3.7890269392315044`*^9, {3.7890269738174143`*^9, 
   3.7890270380120773`*^9}, {3.7890273573663845`*^9, 3.789027370153887*^9}, {
   3.789027408118063*^9, 3.7890274160788717`*^9}, {3.789027525128593*^9, 
   3.78902764598519*^9}, {3.789027677587797*^9, 3.78902772035088*^9}, {
   3.789027752076336*^9, 3.789027784393772*^9}, {3.7890278421195297`*^9, 
   3.789027848467891*^9}, {3.789027879366764*^9, 3.7890279162985106`*^9}, {
   3.7890279961287107`*^9, 3.7890280169665985`*^9}, {3.789028107735612*^9, 
   3.7890281128645277`*^9}, {3.789028147381074*^9, 3.7890282385724897`*^9}, {
   3.7890282725633082`*^9, 3.789028344810417*^9}, {3.7890283755451946`*^9, 
   3.789028450977661*^9}, {3.7890285031852913`*^9, 3.789028544713812*^9}, {
   3.7890324643380632`*^9, 3.7890325758188767`*^9}, {3.789032641633298*^9, 
   3.7890327427016582`*^9}, {3.7890328770077715`*^9, 3.78903307560835*^9}, {
   3.7890359318106427`*^9, 3.789035932008642*^9}, {3.7890379486146765`*^9, 
   3.789037949617454*^9}, {3.7890389089036064`*^9, 3.7890389245012107`*^9}, {
   3.7890390222777205`*^9, 3.789039032151469*^9}, {3.789039188247497*^9, 
   3.7890392652095337`*^9}, 3.7890394915092936`*^9, {3.7890400346546144`*^9, 
   3.78904005785102*^9}, {3.789042512727436*^9, 3.789042514015156*^9}, {
   3.789482782714414*^9, 3.7894827829331636`*^9}, {3.790843725813648*^9, 
   3.7908437749356413`*^9}, {3.790843945040861*^9, 3.7908441005349083`*^9}, {
   3.79084469742492*^9, 3.790844761357546*^9}, {3.7908449665374513`*^9, 
   3.7908449991981263`*^9}, {3.7908450309699793`*^9, 3.7908450502061787`*^9}, 
   3.7908451050400906`*^9, {3.7908451810277057`*^9, 3.7908451912383113`*^9}, {
   3.7908459034609966`*^9, 3.7908459507545223`*^9}, {3.7908461176431317`*^9, 
   3.7908461179595385`*^9}, {3.7908466019254465`*^9, 
   3.7908467198173857`*^9}, {3.7908468888399305`*^9, 3.790846934048202*^9}, {
   3.7908469712347713`*^9, 3.7908469716893024`*^9}, {3.7909079051042857`*^9, 
   3.7909079427643685`*^9}, {3.7909079922911572`*^9, 
   3.7909080021969166`*^9}, {3.790909985821327*^9, 3.790909988130271*^9}, {
   3.79091015267225*^9, 3.790910157717128*^9}, {3.790910376527751*^9, 
   3.790910397554235*^9}, {3.7909104284624796`*^9, 3.79091042966345*^9}, {
   3.7909105061275826`*^9, 3.790910544646642*^9}, 3.790910636663686*^9, {
   3.7909116893537993`*^9, 3.790911796894176*^9}, {3.7909118802965746`*^9, 
   3.7909119918098526`*^9}, {3.7909120472064967`*^9, 
   3.7909120518163867`*^9}, {3.790912083556612*^9, 3.7909122484765854`*^9}, {
   3.79091234368426*^9, 3.790912353491021*^9}, {3.79091250411734*^9, 
   3.7909125842433834`*^9}, {3.7909127387521677`*^9, 
   3.7909127967417574`*^9}, {3.790912993990937*^9, 3.790913023057994*^9}, {
   3.790913412647771*^9, 3.7909134167226667`*^9}, {3.7909134797871275`*^9, 
   3.790913489289897*^9}, {3.790917982265809*^9, 3.7909180243917828`*^9}, {
   3.790918108393732*^9, 3.790918180655965*^9}, {3.7909182264284935`*^9, 
   3.7909182440050645`*^9}, 3.790918318495246*^9, {3.7909183997362394`*^9, 
   3.790918458373805*^9}, {3.7909185646572123`*^9, 3.7909186324525566`*^9}, {
   3.790918679539407*^9, 3.7909188176440372`*^9}, {3.7909188550291224`*^9, 
   3.7909189021979685`*^9}, {3.790918942972975*^9, 3.7909189557166643`*^9}, {
   3.790919174693166*^9, 3.7909192475123887`*^9}, {3.7909193247367444`*^9, 
   3.7909193449602547`*^9}, {3.790919424704063*^9, 3.7909196150214195`*^9}, {
   3.7909196532074847`*^9, 3.7909196939474926`*^9}, {3.7909197945770335`*^9, 
   3.7909198069617333`*^9}, {3.7910160031863527`*^9, 3.791016018185157*^9}, {
   3.791016062809433*^9, 3.7910161733526535`*^9}, {3.7910162489452024`*^9, 
   3.7910162987569733`*^9}, 3.7910164041088047`*^9, 3.7910164598809657`*^9, {
   3.791016530198585*^9, 3.791016559444867*^9}, 3.791016615540489*^9, 
   3.7910166538957453`*^9, {3.7910167292092323`*^9, 3.791016809833393*^9}, {
   3.791016842714589*^9, 3.791016852083356*^9}, {3.791016925933322*^9, 
   3.791016955775276*^9}, {3.7910170628158436`*^9, 3.791017083568331*^9}, {
   3.7910172299547367`*^9, 3.7910172379405346`*^9}, {3.791017374516403*^9, 
   3.7910173867051*^9}, {3.7910185663183537`*^9, 3.7910185712192326`*^9}, {
   3.791018693041989*^9, 3.791018695316489*^9}, {3.7910187332527747`*^9, 
   3.791018842077097*^9}, {3.7910188791347103`*^9, 3.7910189053010674`*^9}, {
   3.791018955733124*^9, 3.7910189656588764`*^9}, {3.7910191941184196`*^9, 
   3.7910192183738227`*^9}, 3.791019260597212*^9, {3.791019295282355*^9, 
   3.791019295844343*^9}, {3.791089516569024*^9, 3.7910895229836683`*^9}, {
   3.7910896983826494`*^9, 3.7910897798056135`*^9}, 3.7910903537254095`*^9, {
   3.791090447668702*^9, 3.7910905437563124`*^9}, {3.791090585582284*^9, 
   3.7910905949060497`*^9}, {3.791090630341486*^9, 3.791090711377494*^9}, {
   3.7910908160329647`*^9, 3.791090816777946*^9}, {3.7910908939438047`*^9, 
   3.791090903904558*^9}, {3.791098107725418*^9, 3.7910982165441127`*^9}, {
   3.7910983423446846`*^9, 3.791098342719671*^9}, {3.7910995084959235`*^9, 
   3.7910995787372026`*^9}, {3.7911001164609833`*^9, 
   3.7911003039604096`*^9}, {3.7911003371110992`*^9, 3.791100355140659*^9}, {
   3.7911003874068613`*^9, 3.7911004045214443`*^9}, {3.7911004584201727`*^9, 
   3.7911004994401646`*^9}, {3.7911006691861944`*^9, 
   3.7911006732560973`*^9}, {3.7911007387078953`*^9, 3.7911007605713577`*^9}, 
   3.7911008258159018`*^9, {3.791130562502917*^9, 3.7911305654264016`*^9}, {
   3.791206779717471*^9, 3.7912067882934227`*^9}, {3.791206886689635*^9, 
   3.7912069198875313`*^9}, {3.7912069635058904`*^9, 3.791207137956523*^9}, {
   3.7912071740064135`*^9, 3.7912072356832037`*^9}, {3.791207305674878*^9, 
   3.7912073266311374`*^9}, {3.7912095339422607`*^9, 3.791209669160851*^9}, {
   3.7912097079191923`*^9, 3.791209764978924*^9}, {3.7912098169137893`*^9, 
   3.791209821155846*^9}, {3.79120988676807*^9, 3.791209887215577*^9}, {
   3.791210055646822*^9, 3.7912100766490993`*^9}, {3.7912101250334845`*^9, 
   3.7912101602162066`*^9}, {3.791210205081773*^9, 3.7912102491041346`*^9}, {
   3.791210281488631*^9, 3.7912103087433558`*^9}, {3.791210387556986*^9, 
   3.791210427098445*^9}, {3.7912104851834445`*^9, 3.7912105339448347`*^9}, {
   3.7912105692360926`*^9, 3.791210888207255*^9}, {3.791211001858008*^9, 
   3.7912110073777456`*^9}, 3.7912110779936914`*^9, {3.791341730267441*^9, 
   3.7913417419214973`*^9}, {3.7913417853146534`*^9, 3.791341798033826*^9}, {
   3.7913595355926447`*^9, 3.7913596023199396`*^9}, {3.791359651552575*^9, 
   3.7913597062433863`*^9}, {3.7913597434718823`*^9, 
   3.7913597740218496`*^9}, {3.7913598126023602`*^9, 3.791359862306981*^9}, {
   3.7913599027928705`*^9, 3.791359926202795*^9}, {3.7913599696895533`*^9, 
   3.791359969921548*^9}, {3.791528747219673*^9, 3.791528827929741*^9}, {
   3.7915288968390913`*^9, 3.7915289702003355`*^9}, {3.791531227788316*^9, 
   3.7915312723522496`*^9}, {3.791532430345541*^9, 3.7915324363043985`*^9}, 
   3.7917154946725683`*^9, {3.7917175987352476`*^9, 3.791717633265417*^9}, {
   3.7917176903000317`*^9, 3.7917179844329023`*^9}, {3.7917191493886623`*^9, 
   3.7917191998544416`*^9}, {3.791719317619587*^9, 3.7917193211025004`*^9}, {
   3.791719928883767*^9, 3.7917199393315153`*^9}, {3.7919921921122885`*^9, 
   3.791992229097124*^9}, {3.7919922611770067`*^9, 3.791992362232455*^9}, {
   3.791992435115878*^9, 3.7919924726572123`*^9}, {3.791992528339139*^9, 
   3.7919925772773113`*^9}, {3.791992607532773*^9, 3.7919926447634306`*^9}, {
   3.791992780587294*^9, 3.79199278333025*^9}, {3.791992817983365*^9, 
   3.791992820820018*^9}, {3.791992922305483*^9, 3.791992953133733*^9}, {
   3.791994009721076*^9, 3.79199410409595*^9}, {3.7919941363315954`*^9, 
   3.7919941627997417`*^9}, {3.7919942015815783`*^9, 3.791994455260667*^9}, {
   3.7919944855065684`*^9, 3.791994546856903*^9}, {3.7919946309580555`*^9, 
   3.79199474786643*^9}, {3.7920389254875913`*^9, 3.792039113892807*^9}, {
   3.79203916337255*^9, 3.7920393202505665`*^9}, {3.7920393786520815`*^9, 
   3.792039380118044*^9}, {3.7920394424354606`*^9, 3.7920394439304223`*^9}, {
   3.792039726241169*^9, 3.79203982138475*^9}, {3.792040046856691*^9, 
   3.792040134683462*^9}, {3.792040254077426*^9, 3.792040254485421*^9}, {
   3.7920403483660336`*^9, 3.792040398843749*^9}, {3.792040501513089*^9, 
   3.792040505391992*^9}, {3.792040595544704*^9, 3.7920406003075857`*^9}, {
   3.792040684915433*^9, 3.792040688527341*^9}, {3.792040743562943*^9, 
   3.792040784374906*^9}, {3.792040901209937*^9, 3.792040925334028*^9}, {
   3.7920410140407734`*^9, 3.792041086887925*^9}, {3.792041289902769*^9, 
   3.792041337551556*^9}, {3.7920415013043966`*^9, 3.7920415548520365`*^9}, {
   3.792044562153653*^9, 3.792044575676306*^9}, 3.7920446552282877`*^9, {
   3.792051770806929*^9, 3.7920518306450343`*^9}, {3.7920519059258633`*^9, 
   3.7920519060278563`*^9}, {3.792051942438936*^9, 3.792052010747198*^9}, {
   3.7920520651548185`*^9, 3.792052065432809*^9}, {3.7920525026306853`*^9, 
   3.7920525050786266`*^9}, {3.792055255809986*^9, 3.7920552984689035`*^9}, {
   3.7920554397570353`*^9, 3.792055479555025*^9}, {3.7920557794534273`*^9, 
   3.7920558144525375`*^9}, {3.79205585687946*^9, 3.7920559060342116`*^9}, {
   3.7920560429307375`*^9, 3.792056109535041*^9}, {3.7920562621481895`*^9, 
   3.7920562656591005`*^9}, {3.7920564039456854`*^9, 
   3.7920564056376414`*^9}, {3.792579033871557*^9, 3.792579040300293*^9}, {
   3.793528457363241*^9, 3.793528467779168*^9}, {3.793528500524481*^9, 
   3.7935287107670364`*^9}, {3.7935288504388247`*^9, 
   3.7935288597830353`*^9}, {3.793529187092718*^9, 3.793529223321805*^9}, {
   3.793529273343186*^9, 3.793529296000224*^9}, {3.7935298288677464`*^9, 
   3.7935298293834305`*^9}, {3.793530048349524*^9, 3.793530168647934*^9}, {
   3.793530223939846*^9, 3.7935303229028196`*^9}, {3.793530371436872*^9, 
   3.793530506385135*^9}, 3.793530594594146*^9, {3.793530919255985*^9, 
   3.7935309208384376`*^9}, {3.7935310379263873`*^9, 
   3.7935310605332737`*^9}, {3.793531092330107*^9, 3.7935311150747995`*^9}, {
   3.793531146226303*^9, 3.7935312169791126`*^9}, {3.7935315972748423`*^9, 
   3.7935317152516384`*^9}, {3.793531812121338*^9, 3.793532113444805*^9}, {
   3.7935322253882666`*^9, 3.7935322891579647`*^9}, {3.793545519140339*^9, 
   3.793545645334453*^9}, {3.793545679516065*^9, 3.793545705934145*^9}, {
   3.7935466833046193`*^9, 3.7935466931544204`*^9}, {3.79354673244337*^9, 
   3.7935469919470944`*^9}, {3.7935471612388535`*^9, 3.793547218149677*^9}, {
   3.79354756787967*^9, 3.7935475999144697`*^9}, {3.793547674575364*^9, 
   3.793548099923788*^9}, {3.793548137745365*^9, 3.7935481612575083`*^9}, {
   3.793548309653058*^9, 3.793548340922778*^9}, {3.793548389823044*^9, 
   3.7935484815122433`*^9}, {3.7935485125367746`*^9, 
   3.7935485523615694`*^9}, {3.79354859956527*^9, 3.7935486042258997`*^9}, {
   3.79354868527063*^9, 3.793548766077558*^9}, {3.7935487985542307`*^9, 
   3.793548814081728*^9}, {3.7935488682963343`*^9, 3.793548895056076*^9}, {
   3.793548940810247*^9, 3.793548985262389*^9}, {3.793549035719508*^9, 
   3.7935491596940584`*^9}, {3.7935491966991196`*^9, 
   3.7935492618800983`*^9}, {3.7935493084941893`*^9, 3.793549596066169*^9}, {
   3.79354965236909*^9, 3.793549654512779*^9}, {3.793549705562194*^9, 
   3.7935497225559025`*^9}, 3.7935497837976804`*^9, {3.793549928437462*^9, 
   3.7935501884173183`*^9}, {3.7935502187084255`*^9, 
   3.7935502671590304`*^9}, {3.793550308222136*^9, 3.7935503580836506`*^9}, {
   3.7935504052860966`*^9, 3.7935505623581996`*^9}, {3.7935505978730345`*^9, 
   3.793550677422594*^9}, {3.793550730056162*^9, 3.7935507578253202`*^9}, {
   3.7935515164283113`*^9, 3.793551549999215*^9}, {3.793551605638599*^9, 
   3.7935516313121376`*^9}, {3.7935516772411575`*^9, 3.793551691998232*^9}, {
   3.793551923043498*^9, 3.7935519265685496`*^9}, {3.793552003170387*^9, 
   3.7935520611809287`*^9}, {3.7935522228875976`*^9, 3.793552226720055*^9}, 
   3.7935522716704874`*^9, 3.7935523399479246`*^9, 3.7935536921222544`*^9, {
   3.793560863041253*^9, 3.793560871396072*^9}, {3.7935611220748796`*^9, 
   3.793561209519915*^9}, {3.793561279572803*^9, 3.7935613350664005`*^9}, 
   3.793561385108461*^9, 3.7935617462228556`*^9, {3.7935944256513147`*^9, 
   3.7935944569707994`*^9}, {3.793594524901266*^9, 3.7935945294979997`*^9}, {
   3.793594651675259*^9, 3.7935946712916408`*^9}, {3.793594712347584*^9, 
   3.793594858856103*^9}, {3.793594920968839*^9, 3.7935949878693166`*^9}, {
   3.79359502389114*^9, 3.793595085766082*^9}, {3.7935951168163605`*^9, 
   3.7935955159745097`*^9}, {3.7935955686745067`*^9, 3.793595569191518*^9}, {
   3.79359574436056*^9, 3.7935957991517944`*^9}, {3.793595908474475*^9, 
   3.7935959510781384`*^9}, {3.7935960067491856`*^9, 
   3.7935960125338316`*^9}, {3.7935965000979233`*^9, 
   3.7935965981384716`*^9}, {3.793596630801141*^9, 3.793596785394478*^9}, {
   3.793597070143655*^9, 3.793597081590699*^9}, {3.793599640654088*^9, 
   3.793599663024818*^9}, {3.793599826970634*^9, 3.793599839201275*^9}, {
   3.793599896262024*^9, 3.7935998986869717`*^9}, {3.793599950954067*^9, 
   3.7935999951006594`*^9}, {3.7936001410486455`*^9, 3.793600155532161*^9}, {
   3.79360081914858*^9, 3.7936008216642103`*^9}, {3.7936470465077543`*^9, 
   3.793647050023389*^9}, {3.7936473388759236`*^9, 3.7936473421752415`*^9}, {
   3.8057680519803877`*^9, 3.8057680949305873`*^9}, {3.8057682122409954`*^9, 
   3.80576823530558*^9}, {3.805768268226799*^9, 3.805768332220476*^9}, 
   3.8057683876433125`*^9, {3.805768562834513*^9, 3.8057686108806005`*^9}, {
   3.8057686885677395`*^9, 3.805768698448243*^9}, 3.8057697358383007`*^9, {
   3.805769773333017*^9, 3.805769797339306*^9}, {3.806154082459614*^9, 
   3.806154203323821*^9}, {3.8061542770005875`*^9, 3.806154367196187*^9}, {
   3.8061543979820275`*^9, 3.806154489430003*^9}, {3.806554544965006*^9, 
   3.8065547543531303`*^9}, {3.8065548389545665`*^9, 
   3.8065549463390045`*^9}, {3.806555019726361*^9, 3.8065552135512996`*^9}, {
   3.806556340977795*^9, 3.8065563595108523`*^9}, {3.8065566158596044`*^9, 
   3.8065566297043114`*^9}, {3.806556859787922*^9, 3.806556930305319*^9}, {
   3.8065570473206525`*^9, 3.8065571309346976`*^9}, {3.8065571859015446`*^9, 
   3.8065572424210443`*^9}, {3.806557273418332*^9, 3.8065574179603553`*^9}, 
   3.806557457064336*^9, {3.8065575840624027`*^9, 3.8065576562584095`*^9}, {
   3.8065577760033197`*^9, 3.8065577884595222`*^9}, {3.8065578313294888`*^9, 
   3.806558062408823*^9}, {3.8065581022159157`*^9, 3.806558134565545*^9}, {
   3.806558195494507*^9, 3.8065583314331527`*^9}, {3.8065583772725363`*^9, 
   3.8065583957318172`*^9}, {3.8065584792813005`*^9, 3.806558493940279*^9}, {
   3.806558530948758*^9, 3.8065586349487963`*^9}, {3.806558728312704*^9, 
   3.8065587644141364`*^9}, 3.8065589378105545`*^9, {3.8065612322980733`*^9, 
   3.8065612645105677`*^9}, {3.8065614400487843`*^9, 
   3.8065614558368354`*^9}, {3.806561890728795*^9, 3.8065619062154274`*^9}, {
   3.806562285850359*^9, 3.8065624081387177`*^9}, {3.806563665183335*^9, 
   3.8065636911899347`*^9}, {3.806563744374525*^9, 3.8065637475776434`*^9}, {
   3.8065643431607513`*^9, 3.8065643557271037`*^9}, {3.8065644094177604`*^9, 
   3.806564413249078*^9}, {3.806564475390706*^9, 3.806564483750638*^9}, 
   3.8065645209518175`*^9, {3.806564568024048*^9, 3.806564577689747*^9}, {
   3.806565239953907*^9, 3.8065654216717243`*^9}, {3.806565485656121*^9, 
   3.8065654951761427`*^9}, {3.806565560273326*^9, 3.8065655653866158`*^9}, {
   3.806565900019122*^9, 3.8065659115519867`*^9}, {3.8066399695399084`*^9, 
   3.8066400206284885`*^9}, {3.806640145264379*^9, 3.806640145326871*^9}, {
   3.8073673134893036`*^9, 3.8073673393586397`*^9}, {3.807367422507509*^9, 
   3.8073674265714035`*^9}, 3.807367506270362*^9, {3.8076837091509953`*^9, 
   3.807683712579914*^9}, {3.807684455058928*^9, 3.8076845148745213`*^9}, {
   3.8076846024064555`*^9, 3.807684606787352*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N1 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["x", "a"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["y", "b"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["z", "c"]}], ")"}]}]}],
  SequenceForm[
  "N1 = ", Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
    1 - $CellContext`b^(-1) $CellContext`y) (
    1 - $CellContext`c^(-1) $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846114272413`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N2 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["x", "a"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["y", "b"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["z", "c"]}], ")"}]}]}],
  SequenceForm[
  "N2 = ", Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
    1 - $CellContext`b^(-1) $CellContext`y) (
    1 - $CellContext`c^(-1) $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846114442425`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N3 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["x", "a"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["y", "b"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["z", "c"]}], ")"}]}]}],
  SequenceForm[
  "N3 = ", Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
    1 + $CellContext`b^(-1) $CellContext`y) (
    1 - $CellContext`c^(-1) $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684611449242*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N4 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["x", "a"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["y", "b"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["z", "c"]}], ")"}]}]}],
  SequenceForm[
  "N4 = ", Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
    1 + $CellContext`b^(-1) $CellContext`y) (
    1 - $CellContext`c^(-1) $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684611452242*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N5 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["x", "a"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["y", "b"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["z", "c"]}], ")"}]}]}],
  SequenceForm[
  "N5 = ", Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
    1 - $CellContext`b^(-1) $CellContext`y) (
    1 + $CellContext`c^(-1) $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684611455242*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N6 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["x", "a"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["y", "b"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["z", "c"]}], ")"}]}]}],
  SequenceForm[
  "N6 = ", Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
    1 - $CellContext`b^(-1) $CellContext`y) (
    1 + $CellContext`c^(-1) $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684611458242*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N7 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["x", "a"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["y", "b"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["z", "c"]}], ")"}]}]}],
  SequenceForm[
  "N7 = ", Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
    1 + $CellContext`b^(-1) $CellContext`y) (
    1 + $CellContext`c^(-1) $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684611462242*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N8 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["x", "a"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["y", "b"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["z", "c"]}], ")"}]}]}],
  SequenceForm[
  "N8 = ", Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
    1 + $CellContext`b^(-1) $CellContext`y) (
    1 + $CellContext`c^(-1) $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846114662414`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0"},
       {"0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0"},
       {"0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}], "0", "0", 
        RowBox[{
         FractionBox["1", "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox["x", "a"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["y", "b"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox["z", "c"]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["N = ", 
   MatrixForm[{{
     Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0}, {
     0, Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0}, {
     0, 0, Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 - $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 - $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 + $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z), 0, 0, 
      Rational[1, 8] (1 - $CellContext`a^(-1) $CellContext`x) (
       1 + $CellContext`b^(-1) $CellContext`y) (
       1 + $CellContext`c^(-1) $CellContext`z)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846115542393`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dN1/dx = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "-", "y"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", "z"}], ")"}]}], 
     RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}]}],
  SequenceForm[
  "dN1/dx = ", 
   Rational[-1, 
     8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c - $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846115942383`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dN1/dy = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", "z"}], ")"}]}], 
     RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}]}],
  SequenceForm[
  "dN1/dy = ", 
   Rational[-1, 
     8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c - $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846115982423`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dN1/dz = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "y"}], ")"}]}], 
     RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}]}],
  SequenceForm[
  "dN1/dz = ", 
   Rational[-1, 
     8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b - $CellContext`y)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846116022387`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Bopsta = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0"},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0"},
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0"},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "x"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "-", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"c", "+", "z"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "x"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"b", "+", "y"}], ")"}]}], 
         RowBox[{"8", " ", "a", " ", "b", " ", "c"}]], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", "y"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"c", "+", "z"}], ")"}]}], 
          RowBox[{"8", " ", "a", " ", "b", " ", "c"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Bopsta = ", 
   MatrixForm[{{
     Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c - $CellContext`z), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c - $CellContext`z), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c - $CellContext`z), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c - $CellContext`z), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c + $CellContext`z), 0, 0, 
      Rational[
       1, 8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c + $CellContext`z), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c + $CellContext`z), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c + $CellContext`z), 0, 0}, {
     0, Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c - $CellContext`z), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c - $CellContext`z), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c - $CellContext`z), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c - $CellContext`z), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c + $CellContext`z), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c + $CellContext`z), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c + $CellContext`z), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c + $CellContext`z), 0}, {
     0, 0, Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b - $CellContext`y), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b - $CellContext`y), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b + $CellContext`y), 0, 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b + $CellContext`y), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b - $CellContext`y), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b - $CellContext`y), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b + $CellContext`y), 0, 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b + $CellContext`y)}, {
     Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c - $CellContext`z), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c - $CellContext`z), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c - $CellContext`z), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c - $CellContext`z), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c - $CellContext`z), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c - $CellContext`z), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c - $CellContext`z), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c - $CellContext`z), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c + $CellContext`z), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c + $CellContext`z), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c + $CellContext`z), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c + $CellContext`z), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c + $CellContext`z), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c + $CellContext`z), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c + $CellContext`z), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c + $CellContext`z), 0}, {
     0, Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b - $CellContext`y), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c - $CellContext`z), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b - $CellContext`y), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c - $CellContext`z), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b + $CellContext`y), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c - $CellContext`z), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b + $CellContext`y), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c - $CellContext`z), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b - $CellContext`y), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c + $CellContext`z), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b - $CellContext`y), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c + $CellContext`z), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b + $CellContext`y), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`c + $CellContext`z), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b + $CellContext`y), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`c + $CellContext`z)}, {
     Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b - $CellContext`y), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c - $CellContext`z), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b - $CellContext`y), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c - $CellContext`z), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b + $CellContext`y), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c - $CellContext`z), 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b + $CellContext`y), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c - $CellContext`z), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b - $CellContext`y), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c + $CellContext`z), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b - $CellContext`y), 0, 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b - $CellContext`y) ($CellContext`c + $CellContext`z), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a + $CellContext`x) ($CellContext`b + $CellContext`y), 0, 
      Rational[
       1, 8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c + $CellContext`z), 
      Rational[1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`a - $CellContext`x) ($CellContext`b + $CellContext`y), 0, 
      Rational[-1, 
        8] $CellContext`a^(-1) $CellContext`b^(-1) $CellContext`c^(-1) \
($CellContext`b + $CellContext`y) ($CellContext`c + $CellContext`z)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684611751235*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dN1/dx = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "0.25`"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2.`", " ", "z"}]}], ")"}]}]}],
  SequenceForm[
  "dN1/dx = ", (-0.25) (1 - 2. $CellContext`y) (1 - 2. $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846117552347`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dN1/dy = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "0.25`"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2.`", " ", "z"}]}], ")"}]}]}],
  SequenceForm[
  "dN1/dy = ", (-0.25) (1 - 2. $CellContext`x) (1 - 2. $CellContext`z)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684611759234*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dN1/dz = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "0.25`"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2.`", " ", "y"}]}], ")"}]}]}],
  SequenceForm[
  "dN1/dz = ", (-0.25) (1 - 2. $CellContext`x) (1 - 2. $CellContext`y)],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846117632346`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Bnumerika = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}]},
       {
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}]},
       {
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}], 
        RowBox[{"0.25`", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2.`", " ", "x"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "0.25`"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "y"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2.`", " ", "z"}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Bnumerika = ", 
   MatrixForm[{{(-0.25) (1 - 2. $CellContext`y) (1 - 2. $CellContext`z), 0, 0,
       0.25 (1 - 2. $CellContext`y) (1 - 2. $CellContext`z), 0, 0, 
      0.25 (1 + 2. $CellContext`y) (1 - 2. $CellContext`z), 0, 
      0, (-0.25) (1 + 2. $CellContext`y) (1 - 2. $CellContext`z), 0, 
      0, (-0.25) (1 - 2. $CellContext`y) (1 + 2. $CellContext`z), 0, 0, 
      0.25 (1 - 2. $CellContext`y) (1 + 2. $CellContext`z), 0, 0, 
      0.25 (1 + 2. $CellContext`y) (1 + 2. $CellContext`z), 0, 
      0, (-0.25) (1 + 2. $CellContext`y) (1 + 2. $CellContext`z), 0, 0}, {
     0, (-0.25) (1 - 2. $CellContext`x) (1 - 2. $CellContext`z), 0, 
      0, (-0.25) (1 + 2. $CellContext`x) (1 - 2. $CellContext`z), 0, 0, 
      0.25 (1 + 2. $CellContext`x) (1 - 2. $CellContext`z), 0, 0, 
      0.25 (1 - 2. $CellContext`x) (1 - 2. $CellContext`z), 0, 
      0, (-0.25) (1 - 2. $CellContext`x) (1 + 2. $CellContext`z), 0, 
      0, (-0.25) (1 + 2. $CellContext`x) (1 + 2. $CellContext`z), 0, 0, 
      0.25 (1 + 2. $CellContext`x) (1 + 2. $CellContext`z), 0, 0, 
      0.25 (1 - 2. $CellContext`x) (1 + 2. $CellContext`z), 0}, {
     0, 0, (-0.25) (1 - 2. $CellContext`x) (1 - 2. $CellContext`y), 0, 
      0, (-0.25) (1 + 2. $CellContext`x) (1 - 2. $CellContext`y), 0, 
      0, (-0.25) (1 + 2. $CellContext`x) (1 + 2. $CellContext`y), 0, 
      0, (-0.25) (1 - 2. $CellContext`x) (1 + 2. $CellContext`y), 0, 0, 
      0.25 (1 - 2. $CellContext`x) (1 - 2. $CellContext`y), 0, 0, 
      0.25 (1 + 2. $CellContext`x) (1 - 2. $CellContext`y), 0, 0, 
      0.25 (1 + 2. $CellContext`x) (1 + 2. $CellContext`y), 0, 0, 
      0.25 (1 - 2. $CellContext`x) (1 + 2. $CellContext`y)}, {(-0.25) (1 - 
       2. $CellContext`x) (1 - 2. $CellContext`z), (-0.25) (1 - 
       2. $CellContext`y) (1 - 2. $CellContext`z), 
      0, (-0.25) (1 + 2. $CellContext`x) (1 - 2. $CellContext`z), 
      0.25 (1 - 2. $CellContext`y) (1 - 2. $CellContext`z), 0, 
      0.25 (1 + 2. $CellContext`x) (1 - 2. $CellContext`z), 
      0.25 (1 + 2. $CellContext`y) (1 - 2. $CellContext`z), 0, 
      0.25 (1 - 2. $CellContext`x) (1 - 2. $CellContext`z), (-0.25) (1 + 
       2. $CellContext`y) (1 - 2. $CellContext`z), 
      0, (-0.25) (1 - 2. $CellContext`x) (1 + 2. $CellContext`z), (-0.25) (1 - 
       2. $CellContext`y) (1 + 2. $CellContext`z), 
      0, (-0.25) (1 + 2. $CellContext`x) (1 + 2. $CellContext`z), 
      0.25 (1 - 2. $CellContext`y) (1 + 2. $CellContext`z), 0, 
      0.25 (1 + 2. $CellContext`x) (1 + 2. $CellContext`z), 
      0.25 (1 + 2. $CellContext`y) (1 + 2. $CellContext`z), 0, 
      0.25 (1 - 2. $CellContext`x) (1 + 2. $CellContext`z), (-0.25) (1 + 
       2. $CellContext`y) (1 + 2. $CellContext`z), 0}, {
     0, (-0.25) (1 - 2. $CellContext`x) (1 - 2. $CellContext`y), (-0.25) (1 - 
       2. $CellContext`x) (1 - 2. $CellContext`z), 
      0, (-0.25) (1 + 2. $CellContext`x) (1 - 2. $CellContext`y), (-0.25) (1 + 
       2. $CellContext`x) (1 - 2. $CellContext`z), 
      0, (-0.25) (1 + 2. $CellContext`x) (1 + 2. $CellContext`y), 
      0.25 (1 + 2. $CellContext`x) (1 - 2. $CellContext`z), 
      0, (-0.25) (1 - 2. $CellContext`x) (1 + 2. $CellContext`y), 
      0.25 (1 - 2. $CellContext`x) (1 - 2. $CellContext`z), 0, 
      0.25 (1 - 2. $CellContext`x) (1 - 2. $CellContext`y), (-0.25) (1 - 
       2. $CellContext`x) (1 + 2. $CellContext`z), 0, 
      0.25 (1 + 2. $CellContext`x) (1 - 2. $CellContext`y), (-0.25) (1 + 
       2. $CellContext`x) (1 + 2. $CellContext`z), 0, 
      0.25 (1 + 2. $CellContext`x) (1 + 2. $CellContext`y), 
      0.25 (1 + 2. $CellContext`x) (1 + 2. $CellContext`z), 0, 
      0.25 (1 - 2. $CellContext`x) (1 + 2. $CellContext`y), 
      0.25 (1 - 2. $CellContext`x) (1 + 2. $CellContext`z)}, {(-0.25) (1 - 
       2. $CellContext`x) (1 - 2. $CellContext`y), 
      0, (-0.25) (1 - 2. $CellContext`y) (1 - 2. $CellContext`z), (-0.25) (1 + 
       2. $CellContext`x) (1 - 2. $CellContext`y), 0, 
      0.25 (1 - 2. $CellContext`y) (1 - 2. $CellContext`z), (-0.25) (1 + 
       2. $CellContext`x) (1 + 2. $CellContext`y), 0, 
      0.25 (1 + 2. $CellContext`y) (1 - 2. $CellContext`z), (-0.25) (1 - 
       2. $CellContext`x) (1 + 2. $CellContext`y), 
      0, (-0.25) (1 + 2. $CellContext`y) (1 - 2. $CellContext`z), 
      0.25 (1 - 2. $CellContext`x) (1 - 2. $CellContext`y), 
      0, (-0.25) (1 - 2. $CellContext`y) (1 + 2. $CellContext`z), 
      0.25 (1 + 2. $CellContext`x) (1 - 2. $CellContext`y), 0, 
      0.25 (1 - 2. $CellContext`y) (1 + 2. $CellContext`z), 
      0.25 (1 + 2. $CellContext`x) (1 + 2. $CellContext`y), 0, 
      0.25 (1 + 2. $CellContext`y) (1 + 2. $CellContext`z), 
      0.25 (1 - 2. $CellContext`x) (1 + 2. $CellContext`y), 
      0, (-0.25) (1 + 2. $CellContext`y) (1 + 2. $CellContext`z)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846117972326`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"D = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3.3333333333333335`", "0.8333333333333334`", "0.8333333333333334`", 
        "0", "0", "0"},
       {"0.8333333333333334`", "3.3333333333333335`", "0.8333333333333334`", 
        "0", "0", "0"},
       {"0.8333333333333334`", "0.8333333333333334`", "3.3333333333333335`", 
        "0", "0", "0"},
       {"0", "0", "0", "1.25`", "0", "0"},
       {"0", "0", "0", "0", "1.25`", "0"},
       {"0", "0", "0", "0", "0", "1.25`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\" * \\!\\(\\*SuperscriptBox[\\(10\\), \\(7\\)]\\)\
\"\>"}],
  SequenceForm["D = ", 
   MatrixForm[{{
     3.3333333333333335`, 0.8333333333333334, 0.8333333333333334, 0, 0, 0}, {
     0.8333333333333334, 3.3333333333333335`, 0.8333333333333334, 0, 0, 0}, {
     0.8333333333333334, 0.8333333333333334, 3.3333333333333335`, 0, 0, 0}, {
     0, 0, 0, 1.25, 0, 0}, {0, 0, 0, 0, 1.25, 0}, {0, 0, 0, 0, 0, 1.25}}], 
   " * \!\(\*SuperscriptBox[\(10\), \(7\)]\)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846118012333`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\!\\(\\*SuperscriptBox[\\(B\\), \\(T\\)]\\)DB = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "y"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}]}], 
           ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
              ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333335`*^6", "-", 
            RowBox[{"5.208333333333335`*^6", " ", "x"}]}], ")"}], " ", "x"}], 
         "+", 
         RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3.3333333333333332`*^7"}], "+", 
            RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", "y"}],
          "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}]}], ")"}], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}]},
       {
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "y"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}]}], 
           ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "y"}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
              ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333335`*^6"}], "-", 
            RowBox[{"5.208333333333335`*^6", " ", "x"}]}], ")"}], " ", "x"}], 
         "+", 
         RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"3.3333333333333332`*^7", "+", 
            RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", "y"}],
          "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333333`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}]}], ")"}], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}]},
       {
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "y"}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "y"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}]}], 
           ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}]},
       {
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
              ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333335`*^6"}], "-", 
            RowBox[{"5.208333333333335`*^6", " ", "x"}]}], ")"}], " ", "x"}], 
         "-", 
         RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3.3333333333333332`*^7"}], "-", 
            RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", "x", 
          " ", "y"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333333`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}]}], ")"}], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}]},
       {
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "y"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}]}], 
           ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}]},
       {
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
              ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333335`*^6", "-", 
            RowBox[{"5.208333333333335`*^6", " ", "x"}]}], ")"}], " ", "x"}], 
         "-", 
         RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3.3333333333333332`*^7", "-", 
            RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", "x", 
          " ", "y"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}]}], ")"}], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}]},
       {
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "y"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}]}], 
           ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}]},
       {
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333335`*^6", "-", 
            RowBox[{"5.208333333333335`*^6", " ", "x"}]}], ")"}], " ", "x"}], 
         "+", 
         RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3.3333333333333332`*^7"}], "+", 
            RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", "y"}],
          "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}]}], ")"}], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
              ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "-", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}]},
       {
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "y"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}]}], 
           ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "y"}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}]},
       {
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1.25`*^7", "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333335`*^6"}], "-", 
            RowBox[{"5.208333333333335`*^6", " ", "x"}]}], ")"}], " ", "x"}], 
         "+", 
         RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"3.3333333333333332`*^7", "+", 
            RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", "y"}],
          "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333333`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}]}], ")"}], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
              ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "-", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "-", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}]},
       {
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "y"}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "y"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}]}], 
           ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}]},
       {
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}]},
       {
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333335`*^6"}], "-", 
            RowBox[{"5.208333333333335`*^6", " ", "x"}]}], ")"}], " ", "x"}], 
         "-", 
         RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3.3333333333333332`*^7"}], "-", 
            RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", "x", 
          " ", "y"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333333`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}]}], ")"}], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "-", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
              ")"}]}]}], ")"}]}]}]},
       {
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "y"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}]}], 
           ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"x", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["x", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}]},
       {
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "-", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"1.0416666666666665`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5.208333333333334`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "-", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6.25`*^6"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "-", 
            RowBox[{"1.0416666666666668`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1.1458333333333334`*^7", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}], " ", "z"}], 
         "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "-", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "y"}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"y", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "y"}]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "z"}]}], ")"}], "2"]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"1.1458333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}], " ", 
             "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}]},
       {
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{"5.208333333333334`*^6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"3.3333333333333336`*^7", " ", 
                SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["y", "2"]}]}], ")"}], " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"520833.33333333326`", "\[VeryThinSpace]", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "3.6458333333333335`*^6"}], "+", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "-", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5.208333333333335`*^6", "+", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"2.0833333333333333`*^6", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "2.0833333333333335`*^6"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{"1.25`*^7", " ", 
             SuperscriptBox["z", "2"]}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
               RowBox[{"1.25`*^7", " ", 
                SuperscriptBox["z", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1.0416666666666665`*^6", "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2.0833333333333333`*^6"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "+", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2.083333333333333`*^6"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "520833.33333333326`"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"2.083333333333333`*^6", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "520833.3333333335`"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5.208333333333335`*^6", "-", 
            RowBox[{"5.208333333333335`*^6", " ", "x"}]}], ")"}], " ", "x"}], 
         "-", 
         RowBox[{"5.208333333333334`*^6", " ", "y"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3.3333333333333332`*^7", "-", 
            RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", "x", 
          " ", "y"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "-", 
               RowBox[{"3.3333333333333332`*^7", " ", "x"}]}], ")"}], " ", 
             "x"}]}], ")"}], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"6.25`*^6", " ", 
          SuperscriptBox["z", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "-", 
               RowBox[{"1.25`*^7", " ", "x"}]}], ")"}], " ", "x"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "y"}]}], ")"}], " ", "y"}]}], ")"}], 
          " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1.3020833333333335`*^6"}], "-", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "-", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         RowBox[{"-", "260416.66666666663`"}], "-", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.0416666666666665`*^6", "+", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}], "+", 
            RowBox[{
             SuperscriptBox["y", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"260416.66666666663`", "\[VeryThinSpace]", "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2.604166666666667`*^6"}], "-", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"520833.33333333326`", " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.0416666666666665`*^6"}], "-", 
            RowBox[{"2.083333333333333`*^6", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"520833.3333333335`", "\[VeryThinSpace]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6.25`*^6"}], "-", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}], " ", "z"}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"3.3333333333333336`*^7", " ", 
             SuperscriptBox["y", "2"]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1.0416666666666665`*^6"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1.041666666666667`*^7"}], "-", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}], "-", 
           RowBox[{"2.0833333333333333`*^6", " ", "z"}]}], ")"}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}]}], 
        RowBox[{"2.0833333333333335`*^6", "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"5.208333333333334`*^6", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1.25`*^7"}], "-", 
                  RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], 
              ")"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"0.5`", "\[VeryThinSpace]", "+", 
            RowBox[{"1.`", " ", "y"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5.208333333333335`*^6"}], "-", 
           RowBox[{"1.041666666666667`*^7", " ", "z"}], "+", 
           RowBox[{"x", " ", 
            RowBox[{"(", 
             RowBox[{"1.041666666666667`*^7", "+", 
              RowBox[{"2.083333333333334`*^7", " ", "z"}]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{"1.3020833333333335`*^6", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5.208333333333334`*^6"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.0416666666666668`*^7"}], "-", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}], "-", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"2.604166666666667`*^6", " ", "z"}], "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"2.604166666666667`*^6", "+", 
            RowBox[{"5.208333333333334`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5.208333333333334`*^6", "+", 
            RowBox[{"1.0416666666666668`*^7", " ", "z"}], "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"1.0416666666666668`*^7", "+", 
               RowBox[{"2.0833333333333336`*^7", " ", "z"}]}], ")"}]}]}], 
           ")"}]}]}], 
        RowBox[{"3.6458333333333335`*^6", "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{"6.25`*^6", "+", 
            RowBox[{"6.25`*^6", " ", "z"}]}], ")"}]}], "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1.1458333333333334`*^7"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3.3333333333333336`*^7"}], "-", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}], " ", 
             "y"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1.25`*^7"}], "-", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}], " ", "z"}]}], ")"}]}],
          "+", 
         RowBox[{"y", " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1.1458333333333334`*^7", "+", 
            RowBox[{"y", " ", 
             RowBox[{"(", 
              RowBox[{"3.3333333333333336`*^7", "+", 
               RowBox[{"3.3333333333333336`*^7", " ", "y"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1.25`*^7", "+", 
               RowBox[{"1.25`*^7", " ", "z"}]}], ")"}]}]}], ")"}]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["\!\(\*SuperscriptBox[\(B\), \(T\)]\)DB = ", 
   MatrixForm[{{
     3.6458333333333335`*^6 + $CellContext`z (-1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`y \
(-1.1458333333333334`*^7 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        6.25*^6 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`y + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, (0.5 - 1. $CellContext`y)^2 (
       5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`z + $CellContext`x \
(-1.041666666666667*^7 + 
         2.083333333333334*^7 $CellContext`z)), -520833.3333333335 + (
        5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + \
$CellContext`y^2 (-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        5.208333333333334*^6 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-1.0416666666666665`*^6 + \
$CellContext`x (1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`y) + 
       2.0833333333333333`*^6 $CellContext`y) (0.5 - 1. $CellContext`z)^2, (
        0.5 - 1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x (
         1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`z) + 
       2.0833333333333333`*^6 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`z (1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`x^2 (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`x^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, -260416.66666666663` + $CellContext`y^2 (
        1.0416666666666665`*^6 - 2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 1.25*^7 $CellContext`x) $CellContext`x + (
          3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`z (-5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`z + $CellContext`x (-1.25*^7 + \
$CellContext`x (1.25*^7 - 1.25*^7 $CellContext`z) + 
          1.25*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) + 
       1.041666666666667*^7 $CellContext`y) (0.5 - 1. $CellContext`z)^2, 
      1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 + $CellContext`y^2 (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 \
(-5.208333333333334*^6 + 1.0416666666666668`*^7 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`y (-5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`y + $CellContext`x (-1.25*^7 + \
$CellContext`x (1.25*^7 - 1.25*^7 $CellContext`y) + 1.25*^7 $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y) \
$CellContext`z^2, 1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), (
        0.5 - 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`z) + 
       1.041666666666667*^7 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`y (1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`y + $CellContext`x^2 (-1.25*^7 + 
          1.25*^7 $CellContext`y)) + 
      5.208333333333334*^6 $CellContext`z^2 + (
        1.25*^7 $CellContext`x^2 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y)) $CellContext`z^2, \
-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), (0.5 - 
        1. $CellContext`y)^2 (-5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x (
         2.0833333333333333`*^6 + 
         2.083333333333334*^7 $CellContext`z)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`y^2 (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`x^2 (6.25*^6 - 
        1.25*^7 $CellContext`y^2 - 
        1.25*^7 $CellContext`z^2), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        520833.33333333326` + $CellContext`y^2 (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 520833.3333333335 - 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (6.25*^6 - 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
          1.25*^7 $CellContext`y^2)) - 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (-1.25*^7 + 
          1.25*^7 $CellContext`x) + 
        3.3333333333333336`*^7 $CellContext`y^2) $CellContext`z^2, 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      260416.66666666663` + $CellContext`y^2 (-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z))}, {(
       5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`y + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, 
      3.6458333333333335`*^6 + $CellContext`z (-1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`x \
(-1.1458333333333334`*^7 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y^2 (
        6.25*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`y) - 
       2.0833333333333333`*^6 $CellContext`y) (0.5 - 1. $CellContext`z)^2, 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 1.25*^7 $CellContext`y) $CellContext`y + (
          3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`z (-5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`z + $CellContext`y (-1.25*^7 + \
$CellContext`y (1.25*^7 - 1.25*^7 $CellContext`z) + 1.25*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), (-5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, -2.0833333333333335`*^6 + $CellContext`z (
        1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`y^2 (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), (-1.0416666666666665`*^6 + \
$CellContext`x (2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`y) + 
       1.041666666666667*^7 $CellContext`y) (0.5 - 
        1. $CellContext`z)^2, -520833.3333333335 + (5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + \
$CellContext`x^2 (-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      2.0833333333333335`*^6 + $CellContext`x (-5.208333333333334*^6 + \
$CellContext`y (-1.25*^7 + 1.25*^7 $CellContext`y) + $CellContext`x (
          5.208333333333334*^6 + (1.25*^7 - 
            1.25*^7 $CellContext`y) $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`x) $CellContext`x + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, 
      260416.66666666663` + $CellContext`y (-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x \
(-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (-1.25*^7 + 1.25*^7 $CellContext`y) + 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y (6.25*^6 - 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-6.25*^6 + 
          1.25*^7 $CellContext`z^2)), 
      260416.66666666663` + $CellContext`y (-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`x^2 (
        1.1458333333333334`*^7 - 1.25*^7 $CellContext`y^2 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y^2 (6.25*^6 - 
        1.25*^7 $CellContext`z^2), -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -2.0833333333333335`*^6 + \
$CellContext`x (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`y^2)) + 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x \
(-3.3333333333333336`*^7 + 3.3333333333333336`*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x (
        5.208333333333334*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z))}, {(
        0.5 - 1. $CellContext`y)^2 (5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`z + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (-6.25*^6 + 
        6.25*^6 $CellContext`z) + $CellContext`y (-1.1458333333333334`*^7 + (
          1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x \
(-1.1458333333333334`*^7 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), (0.5 - 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`z) - 
       2.0833333333333333`*^6 $CellContext`z), 1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + (
          3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y \
(-5.208333333333334*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z) + $CellContext`y (
          5.208333333333334*^6 + (1.25*^7 - 
            1.25*^7 $CellContext`z) $CellContext`z)), 260416.66666666663` - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      520833.3333333335 + (6.25*^6 - 
        6.25*^6 $CellContext`z) $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), 1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 + $CellContext`y^2 (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 \
(-5.208333333333334*^6 + 1.0416666666666668`*^7 $CellContext`z), 
      260416.66666666663` + $CellContext`y (2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), (0.5 - 
        1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x (
         2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`z) + 
       1.041666666666667*^7 $CellContext`z), -260416.66666666663` + \
$CellContext`y (520833.33333333326` - 5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x (
        1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -520833.3333333335 + (
        5.208333333333335*^6 - 
        5.208333333333335*^6 $CellContext`x) $CellContext`x + 
      5.208333333333334*^6 $CellContext`y + $CellContext`x \
(-3.3333333333333332`*^7 + 
        3.3333333333333332`*^7 $CellContext`x) $CellContext`y + \
(-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333332`*^7 $CellContext`x) $CellContext`x) \
$CellContext`y^2 - 
      6.25*^6 $CellContext`z^2 + ((1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, (0.5 - 
        1. $CellContext`y)^2 (-5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x \
(-2.0833333333333333`*^6 + 
         2.083333333333334*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (520833.33333333326` - 5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + 
        1.25*^7 $CellContext`z^2) + $CellContext`y (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`z^2)), -1.3020833333333335`*^6 + \
$CellContext`y^2 (5.208333333333334*^6 - 2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-520833.33333333326` + $CellContext`y^2 (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -1.3020833333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      6.25*^6 $CellContext`z^2 + $CellContext`y^2 (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2) + $CellContext`x^2 (1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 - 
        1.25*^7 $CellContext`z^2), -260416.66666666663` + $CellContext`y^2 (
        1.0416666666666665`*^6 - 1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + \
$CellContext`x (
        5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
          3.3333333333333336`*^7 $CellContext`y^2)) + ($CellContext`x \
(-1.25*^7 + 1.25*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2}, {-520833.3333333335 + (
        5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + \
$CellContext`y^2 (-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        5.208333333333334*^6 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`y) - 
       2.0833333333333333`*^6 $CellContext`y) (0.5 - 1. $CellContext`z)^2, (
        0.5 - 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`z) - 
       2.0833333333333333`*^6 $CellContext`z), 
      3.6458333333333335`*^6 + $CellContext`z (-1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`y \
(-1.1458333333333334`*^7 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x (
        6.25*^6 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        6.25*^6 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`y + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, (0.5 - 
        1. $CellContext`y)^2 (-5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`z + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`z (-5.208333333333334*^6 + \
$CellContext`x (1.25*^7 + $CellContext`x (1.25*^7 - 1.25*^7 $CellContext`z) - 
          1.25*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z), \
(-1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) - 
       1.041666666666667*^7 $CellContext`y) (0.5 - 
        1. $CellContext`z)^2, -1.3020833333333335`*^6 + $CellContext`y^2 (
        5.208333333333334*^6 - 1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 + $CellContext`y^2 (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`z (1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`x^2 (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`x^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, 260416.66666666663` - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`y (1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`y + $CellContext`x^2 (-1.25*^7 + 
          1.25*^7 $CellContext`y)) + 
      5.208333333333334*^6 $CellContext`z^2 + (
        1.25*^7 $CellContext`x^2 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y)) $CellContext`z^2, 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), (0.5 - 
        1. $CellContext`y)^2 (5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y (-5.208333333333334*^6 + \
$CellContext`x (1.25*^7 + $CellContext`x (1.25*^7 - 1.25*^7 $CellContext`y) - 
          1.25*^7 $CellContext`y) + 5.208333333333334*^6 $CellContext`y) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y) \
$CellContext`z^2, -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), (
        0.5 - 1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x \
(-2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`z) - 
       1.041666666666667*^7 $CellContext`z), 520833.3333333335 - 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
          1.25*^7 $CellContext`y^2)) - 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (1.25*^7 + 
          1.25*^7 $CellContext`x) + 
        3.3333333333333336`*^7 $CellContext`y^2) $CellContext`z^2, \
-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -260416.66666666663` - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y^2 (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x \
(-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`y^2 (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`x^2 (6.25*^6 - 
        1.25*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      1.3020833333333335`*^6 + $CellContext`y^2 (-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        520833.33333333326` + $CellContext`y^2 (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z)}, {(-1.0416666666666665`*^6 + \
$CellContext`x (1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`y) + 
       2.0833333333333333`*^6 $CellContext`y) (0.5 - 1. $CellContext`z)^2, 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 1.25*^7 $CellContext`y) $CellContext`y + (
          3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`z (-5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`z + $CellContext`y (-1.25*^7 + \
$CellContext`y (1.25*^7 - 1.25*^7 $CellContext`z) + 1.25*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), (-5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`y + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, 
      3.6458333333333335`*^6 + $CellContext`z (-1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`y (-6.25*^6 + (
          1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y^2 (
        6.25*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x (
        1.1458333333333334`*^7 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) - 
       1.041666666666667*^7 $CellContext`y) (0.5 - 
        1. $CellContext`z)^2, -520833.3333333335 + (5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + $CellContext`x \
(-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), -260416.66666666663` + \
$CellContext`y (2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z), (5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, -2.0833333333333335`*^6 + $CellContext`z (
        1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`y^2 (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), -260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (-1.25*^7 + 1.25*^7 $CellContext`y) + 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y (6.25*^6 - 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-6.25*^6 + 
          1.25*^7 $CellContext`z^2)), 
      260416.66666666663` + $CellContext`y (-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      2.0833333333333335`*^6 + $CellContext`x (
        5.208333333333334*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + $CellContext`x (
          5.208333333333334*^6 + (1.25*^7 - 
            1.25*^7 $CellContext`y) $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`x) $CellContext`x + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, 
      260416.66666666663` + $CellContext`y (-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        1.0416666666666665`*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), 260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -2.0833333333333335`*^6 + \
$CellContext`x (-1.1458333333333334`*^7 + 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`y^2)) + 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (
          3.3333333333333336`*^7 + 3.3333333333333336`*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 \
(-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`x^2 (
        1.1458333333333334`*^7 - 1.25*^7 $CellContext`y^2 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y^2 (6.25*^6 - 
        1.25*^7 $CellContext`z^2), -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y (
        520833.33333333326` + 5.208333333333334*^6 $CellContext`z)}, {(0.5 - 
        1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x (
         1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`z) + 
       2.0833333333333333`*^6 $CellContext`z), 1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + (
          3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y \
(-5.208333333333334*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z) + $CellContext`y (
          5.208333333333334*^6 + (1.25*^7 - 
            1.25*^7 $CellContext`z) $CellContext`z)), (0.5 - 
        1. $CellContext`y)^2 (-5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`z + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (-6.25*^6 + 
        6.25*^6 $CellContext`z) + $CellContext`y (-1.1458333333333334`*^7 + (
          1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x (
        1.1458333333333334`*^7 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), -1.3020833333333335`*^6 + \
$CellContext`y^2 (5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 + $CellContext`y^2 (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 
      260416.66666666663` + $CellContext`y (2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z, 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), -260416.66666666663` + \
$CellContext`y^2 (1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      520833.3333333335 + (6.25*^6 - 
        6.25*^6 $CellContext`z) $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), (0.5 - 1. $CellContext`y)^2 (
       5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x \
(-2.0833333333333333`*^6 + 
         2.083333333333334*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (520833.33333333326` - 5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + 
        1.25*^7 $CellContext`z^2) + $CellContext`y (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`z^2)), (0.5 - 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`z) - 
       1.041666666666667*^7 $CellContext`z), -260416.66666666663` + \
$CellContext`y (520833.33333333326` - 5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), -520833.3333333335 + \
(-5.208333333333335*^6 - 5.208333333333335*^6 $CellContext`x) $CellContext`x + 
      5.208333333333334*^6 $CellContext`y + $CellContext`x (
        3.3333333333333332`*^7 + 
        3.3333333333333332`*^7 $CellContext`x) $CellContext`y + \
(-5.208333333333333*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333332`*^7 $CellContext`x) $CellContext`x) \
$CellContext`y^2 - 
      6.25*^6 $CellContext`z^2 + ((-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, 
      260416.66666666663` - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x (
        520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
          3.3333333333333336`*^7 $CellContext`y^2)) + ($CellContext`x (
          1.25*^7 + 1.25*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, 1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-520833.33333333326` + $CellContext`y^2 (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -1.3020833333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      6.25*^6 $CellContext`z^2 + $CellContext`y^2 (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2) + $CellContext`x^2 (1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 - 
        1.25*^7 $CellContext`z^2)}, {-2.0833333333333335`*^6 + $CellContext`z \
(1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`x^2 (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`x^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, 260416.66666666663` - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`z (-5.208333333333334*^6 + \
$CellContext`x (1.25*^7 + $CellContext`x (1.25*^7 - 1.25*^7 $CellContext`z) - 
          1.25*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z), (
       1.0416666666666665`*^6 + $CellContext`x (2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) - 
       1.041666666666667*^7 $CellContext`y) (0.5 - 
        1. $CellContext`z)^2, -1.3020833333333335`*^6 + $CellContext`y^2 (
        5.208333333333334*^6 - 1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 + $CellContext`y^2 (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 
      3.6458333333333335`*^6 + $CellContext`z (-1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`x (
        6.25*^6 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        6.25*^6 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y (
        1.1458333333333334`*^7 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`y + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, (0.5 + 
        1. $CellContext`y)^2 (-5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`z + $CellContext`x \
(-1.041666666666667*^7 + 
         2.083333333333334*^7 $CellContext`z)), -520833.3333333335 + (
        5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + $CellContext`y \
(-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          
          1.25*^7 $CellContext`z) $CellContext`z), (-1.0416666666666665`*^6 + \
$CellContext`x (-1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`y) - 
       2.0833333333333333`*^6 $CellContext`y) (0.5 - 1. $CellContext`z)^2, (
        0.5 + 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`z) - 
       2.0833333333333333`*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`y^2 (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`x^2 (6.25*^6 - 
        1.25*^7 $CellContext`y^2 - 
        1.25*^7 $CellContext`z^2), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      1.3020833333333335`*^6 + $CellContext`y^2 (-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        520833.33333333326` + $CellContext`y^2 (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 520833.3333333335 - 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
          1.25*^7 $CellContext`y^2)) - 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (1.25*^7 + 
          1.25*^7 $CellContext`x) + 
        3.3333333333333336`*^7 $CellContext`y^2) $CellContext`z^2, 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -260416.66666666663` - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y^2 (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x \
(-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y (
        5.208333333333334*^6 + $CellContext`x (-1.25*^7 + $CellContext`x \
(-1.25*^7 - 1.25*^7 $CellContext`y) - 1.25*^7 $CellContext`y) + 
        5.208333333333334*^6 $CellContext`y) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y) \
$CellContext`z^2, 1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), (
        0.5 + 1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x \
(-2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`z) - 
       1.041666666666667*^7 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`y (-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`y + $CellContext`x^2 (1.25*^7 + 
          1.25*^7 $CellContext`y)) + 
      5.208333333333334*^6 $CellContext`z^2 + (
        1.25*^7 $CellContext`x^2 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y)) $CellContext`z^2, \
-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), (0.5 + 
        1. $CellContext`y)^2 (5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x (
         2.0833333333333333`*^6 + 
         2.083333333333334*^7 $CellContext`z))}, {(-5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, -2.0833333333333335`*^6 + $CellContext`z (
        1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`y^2 (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), (-1.0416666666666665`*^6 + \
$CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) - 
       1.041666666666667*^7 $CellContext`y) (0.5 - 
        1. $CellContext`z)^2, -520833.3333333335 + (5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + $CellContext`x \
(-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), 
      260416.66666666663` + $CellContext`y (2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z, (5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`y + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, 
      3.6458333333333335`*^6 + $CellContext`z (-1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`y (
        6.25*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        6.25*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x (
        1.1458333333333334`*^7 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 \
(-5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (-1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`y) + 
       2.0833333333333333`*^6 $CellContext`y) (0.5 - 1. $CellContext`z)^2, 
      2.0833333333333335`*^6 + $CellContext`z (-5.208333333333334*^6 + \
$CellContext`y (1.25*^7 + $CellContext`y (1.25*^7 - 1.25*^7 $CellContext`z) - 
          1.25*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (3.3333333333333336`*^7 - 
          
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z), \
-1.3020833333333335`*^6 + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`x^2 (
        1.1458333333333334`*^7 - 1.25*^7 $CellContext`y^2 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y^2 (6.25*^6 - 
        1.25*^7 $CellContext`z^2), 
      1.3020833333333335`*^6 + $CellContext`x^2 (-5.208333333333334*^6 + \
$CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -2.0833333333333335`*^6 + \
$CellContext`x (-1.1458333333333334`*^7 + 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`y^2)) + 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (
          3.3333333333333336`*^7 + 3.3333333333333336`*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, 1.3020833333333335`*^6 + 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      2.0833333333333335`*^6 + $CellContext`x (
        5.208333333333334*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + $CellContext`x (
          5.208333333333334*^6 + (-1.25*^7 - 
            1.25*^7 $CellContext`y) $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`x) $CellContext`x + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, \
-260416.66666666663` + $CellContext`x (-1.0416666666666665`*^6 + \
$CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`y \
(-520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z, 260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (1.25*^7 + 1.25*^7 $CellContext`y) + 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y (-6.25*^6 + 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-6.25*^6 + 
          1.25*^7 $CellContext`z^2)), -260416.66666666663` + $CellContext`y \
(-520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z))}, {-260416.66666666663` + \
$CellContext`y^2 (1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      520833.3333333335 + (6.25*^6 - 
        6.25*^6 $CellContext`z) $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), -1.3020833333333335`*^6 + \
$CellContext`y^2 (5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 + $CellContext`y^2 (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -260416.66666666663` + \
$CellContext`y (2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), (0.5 + 
        1. $CellContext`y)^2 (-5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`z + $CellContext`x \
(-1.041666666666667*^7 + 
         2.083333333333334*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 \
(-5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (-6.25*^6 + 
        6.25*^6 $CellContext`z) + $CellContext`y (
        1.1458333333333334`*^7 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x (
        1.1458333333333334`*^7 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), (0.5 + 
        1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x (
         1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`z) + 
       2.0833333333333333`*^6 $CellContext`z), -1.3020833333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 5.208333333333334*^6 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + \
(-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        5.208333333333334*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z + $CellContext`y (
          5.208333333333334*^6 + (1.25*^7 - 
            1.25*^7 $CellContext`z) $CellContext`z)), 1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-520833.33333333326` + $CellContext`y^2 (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      6.25*^6 $CellContext`z^2 + $CellContext`y^2 (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2) + $CellContext`x^2 (1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), 
      260416.66666666663` - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x (
        520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
          3.3333333333333336`*^7 $CellContext`y^2)) + ($CellContext`x (
          1.25*^7 + 1.25*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, (0.5 + 
        1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`z) - 
       1.041666666666667*^7 $CellContext`z), 
      260416.66666666663` + $CellContext`x (
        1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`y (
        520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z, -520833.3333333335 + \
(-5.208333333333335*^6 - 5.208333333333335*^6 $CellContext`x) $CellContext`x - 
      5.208333333333334*^6 $CellContext`y + (-3.3333333333333332`*^7 - 
        3.3333333333333332`*^7 $CellContext`x) $CellContext`x $CellContext`y + \
(-5.208333333333333*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333332`*^7 $CellContext`x) $CellContext`x) \
$CellContext`y^2 - 
      6.25*^6 $CellContext`z^2 + ((-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, (0.5 + 
        1. $CellContext`y)^2 (5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + 
        1.25*^7 $CellContext`z^2) + $CellContext`y (-1.1458333333333334`*^7 + 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`z^2))}, {
     2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 1.25*^7 $CellContext`x) $CellContext`x + (
          3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`z (-5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`z + $CellContext`x (-1.25*^7 + \
$CellContext`x (1.25*^7 - 1.25*^7 $CellContext`z) + 
          1.25*^7 $CellContext`z)), (-1.0416666666666665`*^6 + $CellContext`x \
(2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`y) + 
       1.041666666666667*^7 $CellContext`y) (0.5 - 1. $CellContext`z)^2, 
      1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 + $CellContext`y^2 (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 \
(-5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`z (1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`x^2 (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`x^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, -260416.66666666663` + $CellContext`y^2 (
        1.0416666666666665`*^6 - 2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), -520833.3333333335 + (
        5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + $CellContext`y \
(-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), (
       1.0416666666666665`*^6 + $CellContext`x (-1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`y) + 
       2.0833333333333333`*^6 $CellContext`y) (0.5 - 1. $CellContext`z)^2, (
        0.5 + 1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x (
         1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`z) + 
       2.0833333333333333`*^6 $CellContext`z), 
      3.6458333333333335`*^6 + $CellContext`z (-1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`x (-6.25*^6 + \
(-1.25*^7 - 1.25*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        6.25*^6 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y (
        1.1458333333333334`*^7 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`y + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, (0.5 + 1. $CellContext`y)^2 (
       5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`z + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`z)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (6.25*^6 - 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
          1.25*^7 $CellContext`y^2)) - 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (-1.25*^7 + 
          1.25*^7 $CellContext`x) + 
        3.3333333333333336`*^7 $CellContext`y^2) $CellContext`z^2, \
-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      260416.66666666663` + $CellContext`y^2 (-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`y^2 (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`x^2 (6.25*^6 - 
        1.25*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        520833.33333333326` + $CellContext`y^2 (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`y (-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`y + $CellContext`x^2 (1.25*^7 + 
          1.25*^7 $CellContext`y)) + 
      5.208333333333334*^6 $CellContext`z^2 + (
        1.25*^7 $CellContext`x^2 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y)) $CellContext`z^2, 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), (0.5 + 
        1. $CellContext`y)^2 (-5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y (5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`y + $CellContext`x (
          1.25*^7 + $CellContext`x (-1.25*^7 - 1.25*^7 $CellContext`y) + 
          1.25*^7 $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y) \
$CellContext`z^2, -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), (
        0.5 + 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`z) + 
       1.041666666666667*^7 $CellContext`z)}, {(
       1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) + 
       1.041666666666667*^7 $CellContext`y) (0.5 - 
        1. $CellContext`z)^2, -520833.3333333335 + (5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + \
$CellContext`x^2 (-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), (
       5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, -2.0833333333333335`*^6 + $CellContext`z (
        1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`y^2 (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), (-1.0416666666666665`*^6 + \
$CellContext`x (-1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`y) - 
       2.0833333333333333`*^6 $CellContext`y) (0.5 - 1. $CellContext`z)^2, 
      2.0833333333333335`*^6 + $CellContext`z (-5.208333333333334*^6 + \
$CellContext`y (1.25*^7 + $CellContext`y (1.25*^7 - 1.25*^7 $CellContext`z) - 
          1.25*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z), \
-1.3020833333333335`*^6 + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z), (-5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`y + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 - 
        1. $CellContext`z)^2, 
      3.6458333333333335`*^6 + $CellContext`z (-1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`x \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (3.3333333333333336`*^7 - 
          
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y (
        6.25*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        6.25*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + \
$CellContext`x (
        5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -2.0833333333333335`*^6 + \
$CellContext`x (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`y^2)) + 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x \
(-3.3333333333333336`*^7 + 3.3333333333333336`*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, 
      1.3020833333333335`*^6 + $CellContext`x (-5.208333333333334*^6 + \
$CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`x^2 (
        1.1458333333333334`*^7 - 1.25*^7 $CellContext`y^2 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y^2 (6.25*^6 - 
        1.25*^7 $CellContext`z^2), 
      1.3020833333333335`*^6 + $CellContext`x^2 (-5.208333333333334*^6 + \
$CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (1.25*^7 + 1.25*^7 $CellContext`y) + 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y (-6.25*^6 + 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-6.25*^6 + 
          1.25*^7 $CellContext`z^2)), -260416.66666666663` + $CellContext`y \
(-520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      2.0833333333333335`*^6 + $CellContext`x (-5.208333333333334*^6 + \
$CellContext`y (1.25*^7 + 1.25*^7 $CellContext`y) + $CellContext`x (
          5.208333333333334*^6 + (-1.25*^7 - 
            1.25*^7 $CellContext`y) $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`x) $CellContext`x + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, \
-260416.66666666663` + $CellContext`x^2 (-1.0416666666666665`*^6 + \
$CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`y \
(-520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z))}, {
     1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 + $CellContext`y^2 (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 \
(-5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z), -260416.66666666663` + \
$CellContext`y (2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), 260416.66666666663` - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 \
(-1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      520833.3333333335 + (6.25*^6 - 
        6.25*^6 $CellContext`z) $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), (0.5 + 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`z) - 
       2.0833333333333333`*^6 $CellContext`z), -1.3020833333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 5.208333333333334*^6 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + \
(-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        5.208333333333334*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z + $CellContext`y (
          5.208333333333334*^6 + (1.25*^7 - 
            1.25*^7 $CellContext`z) $CellContext`z)), (0.5 + 
        1. $CellContext`y)^2 (5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`z + $CellContext`x \
(-1.041666666666667*^7 + 
         2.083333333333334*^7 $CellContext`z)), -1.3020833333333335`*^6 + \
$CellContext`x (
        5.208333333333334*^6 + $CellContext`y (1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y \
(-2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (-6.25*^6 + 
        6.25*^6 $CellContext`z) + $CellContext`x (-1.1458333333333334`*^7 + \
(-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        1.1458333333333334`*^7 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (-1.25*^7 + 
          1.25*^7 $CellContext`z)), -260416.66666666663` + $CellContext`y^2 (
        1.0416666666666665`*^6 - 1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
          3.3333333333333336`*^7 $CellContext`y^2)) + ($CellContext`x \
(-1.25*^7 + 1.25*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, -1.3020833333333335`*^6 + \
$CellContext`y^2 (5.208333333333334*^6 - 2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-520833.33333333326` + $CellContext`y^2 (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      6.25*^6 $CellContext`z^2 + $CellContext`y^2 (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2) + $CellContext`x^2 (1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), (
        0.5 + 1. $CellContext`y)^2 (-5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + 
        1.25*^7 $CellContext`z^2) + $CellContext`y (-1.1458333333333334`*^7 + 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`z^2)), (0.5 + 
        1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x (
         2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`z) + 
       1.041666666666667*^7 $CellContext`z), 
      260416.66666666663` + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`y (
        520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -520833.3333333335 + (
        5.208333333333335*^6 - 
        5.208333333333335*^6 $CellContext`x) $CellContext`x - 
      5.208333333333334*^6 $CellContext`y + (3.3333333333333332`*^7 - 
        3.3333333333333332`*^7 $CellContext`x) $CellContext`x $CellContext`y + \
(-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333332`*^7 $CellContext`x) $CellContext`x) \
$CellContext`y^2 - 
      6.25*^6 $CellContext`z^2 + ((1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2}, {
     2.0833333333333335`*^6 + $CellContext`y (-5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`y + $CellContext`x (-1.25*^7 + \
$CellContext`x (1.25*^7 - 1.25*^7 $CellContext`y) + 1.25*^7 $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y) \
$CellContext`z^2, 1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), (
        0.5 - 1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x (
         2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`z) + 
       1.041666666666667*^7 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`y (1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`y + $CellContext`x^2 (-1.25*^7 + 
          1.25*^7 $CellContext`y)) + 
      5.208333333333334*^6 $CellContext`z^2 + (
        1.25*^7 $CellContext`x^2 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y)) $CellContext`z^2, \
-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), (0.5 - 
        1. $CellContext`y)^2 (5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x \
(-2.0833333333333333`*^6 + 
         2.083333333333334*^7 $CellContext`z)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`y^2 (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`x^2 (6.25*^6 - 
        1.25*^7 $CellContext`y^2 - 
        1.25*^7 $CellContext`z^2), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-520833.33333333326` + $CellContext`y^2 (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 520833.3333333335 - 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (6.25*^6 - 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
          1.25*^7 $CellContext`y^2)) - 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (-1.25*^7 + 
          1.25*^7 $CellContext`x) + 
        3.3333333333333336`*^7 $CellContext`y^2) $CellContext`z^2, 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -260416.66666666663` + \
$CellContext`y^2 (1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`y \
(-1.1458333333333334`*^7 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        6.25*^6 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`y + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, (0.5 - 
        1. $CellContext`y)^2 (-5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`z + $CellContext`x (
         1.041666666666667*^7 + 
         2.083333333333334*^7 $CellContext`z)), -520833.3333333335 + \
(-5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + \
$CellContext`y^2 (-5.208333333333334*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        5.208333333333334*^6 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-1.0416666666666665`*^6 + \
$CellContext`x (1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`y) + 
       2.0833333333333333`*^6 $CellContext`y) (0.5 + 1. $CellContext`z)^2, (
        0.5 - 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (-1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`z) + 
       2.0833333333333333`*^6 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`z (-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`x^2 (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`x^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, 
      260416.66666666663` + $CellContext`y^2 (-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`z (5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`z + $CellContext`x (
          1.25*^7 + $CellContext`x (-1.25*^7 - 1.25*^7 $CellContext`z) + 
          1.25*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) + 
       1.041666666666667*^7 $CellContext`y) (0.5 + 
        1. $CellContext`z)^2, -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        2.604166666666667*^6 + $CellContext`y^2 (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 (
        5.208333333333334*^6 + 1.0416666666666668`*^7 $CellContext`z)}, {
     1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      2.0833333333333335`*^6 + $CellContext`x (-5.208333333333334*^6 + \
$CellContext`y (-1.25*^7 + 1.25*^7 $CellContext`y) + $CellContext`x (
          5.208333333333334*^6 + (1.25*^7 - 
            1.25*^7 $CellContext`y) $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`x) $CellContext`x + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, \
-260416.66666666663` + $CellContext`y (520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x (
        1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (-1.25*^7 + 1.25*^7 $CellContext`y) + 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y (6.25*^6 - 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-6.25*^6 + 
          1.25*^7 $CellContext`z^2)), -260416.66666666663` + $CellContext`y (
        520833.33333333326` - 5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`x^2 (
        1.1458333333333334`*^7 - 1.25*^7 $CellContext`y^2 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y^2 (6.25*^6 - 
        1.25*^7 $CellContext`z^2), 1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -2.0833333333333335`*^6 + \
$CellContext`x (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`y^2)) + 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x \
(-3.3333333333333336`*^7 + 3.3333333333333336`*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, 1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), (
       5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`y + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, 
      3.6458333333333335`*^6 + $CellContext`z (1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`x \
(-1.1458333333333334`*^7 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y^2 (
        6.25*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`y) - 
       2.0833333333333333`*^6 $CellContext`y) (0.5 + 1. $CellContext`z)^2, 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`z (5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`z + $CellContext`y (
          1.25*^7 + $CellContext`y (-1.25*^7 - 1.25*^7 $CellContext`z) + 
          1.25*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), (-5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, -2.0833333333333335`*^6 + $CellContext`z \
(-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`y^2 (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), (-1.0416666666666665`*^6 + \
$CellContext`x (2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`y) + 
       1.041666666666667*^7 $CellContext`y) (0.5 + 
        1. $CellContext`z)^2, -520833.3333333335 + (-5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + \
$CellContext`x^2 (-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z))}, {(0.5 - 
        1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`z) + 
       1.041666666666667*^7 $CellContext`z), 
      260416.66666666663` + $CellContext`y (-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x \
(-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -520833.3333333335 + (
        5.208333333333335*^6 - 
        5.208333333333335*^6 $CellContext`x) $CellContext`x + 
      5.208333333333334*^6 $CellContext`y + $CellContext`x \
(-3.3333333333333332`*^7 + 
        3.3333333333333332`*^7 $CellContext`x) $CellContext`y + \
(-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333332`*^7 $CellContext`x) $CellContext`x) \
$CellContext`y^2 - 
      6.25*^6 $CellContext`z^2 + ((1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, (0.5 - 
        1. $CellContext`y)^2 (5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + 
        1.25*^7 $CellContext`z^2) + $CellContext`y (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`z^2)), 
      1.3020833333333335`*^6 + $CellContext`y^2 (-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        520833.33333333326` + $CellContext`y^2 (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 
      1.3020833333333335`*^6 + $CellContext`x^2 (-5.208333333333334*^6 + \
$CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      6.25*^6 $CellContext`z^2 + $CellContext`y^2 (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2) + $CellContext`x^2 (1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), 
      260416.66666666663` + $CellContext`y^2 (-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 + $CellContext`x (-5.208333333333334*^6 + \
$CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
          3.3333333333333336`*^7 $CellContext`y^2)) + ($CellContext`x \
(-1.25*^7 + 1.25*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, (0.5 - 
        1. $CellContext`y)^2 (-5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`z + $CellContext`x (
         1.041666666666667*^7 + 
         2.083333333333334*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (6.25*^6 + 
        6.25*^6 $CellContext`z) + $CellContext`y (-1.1458333333333334`*^7 + \
(-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x \
(-1.1458333333333334`*^7 + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)), (0.5 - 
        1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x \
(-1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`z) - 
       2.0833333333333333`*^6 $CellContext`z), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + (
          3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y \
(-5.208333333333334*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z) + $CellContext`y (
          5.208333333333334*^6 + (-1.25*^7 - 
            1.25*^7 $CellContext`z) $CellContext`z)), -260416.66666666663` - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (-2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      520833.3333333335 + (-6.25*^6 - 
        6.25*^6 $CellContext`z) $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        2.604166666666667*^6 + $CellContext`y^2 (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 (
        5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z), -260416.66666666663` + \
$CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + \
(-1.25*^7 - 1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z))}, {-2.0833333333333335`*^6 + \
$CellContext`y (1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`y + $CellContext`x^2 (-1.25*^7 + 
          1.25*^7 $CellContext`y)) + 
      5.208333333333334*^6 $CellContext`z^2 + (
        1.25*^7 $CellContext`x^2 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y)) $CellContext`z^2, 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), (0.5 - 
        1. $CellContext`y)^2 (-5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y (-5.208333333333334*^6 + \
$CellContext`x (1.25*^7 + $CellContext`x (1.25*^7 - 1.25*^7 $CellContext`y) - 
          1.25*^7 $CellContext`y) + 5.208333333333334*^6 $CellContext`y) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y) \
$CellContext`z^2, -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), (
        0.5 - 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`z) - 
       1.041666666666667*^7 $CellContext`z), 520833.3333333335 - 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
          1.25*^7 $CellContext`y^2)) - 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (1.25*^7 + 
          1.25*^7 $CellContext`x) + 
        3.3333333333333336`*^7 $CellContext`y^2) $CellContext`z^2, \
-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      260416.66666666663` - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x (
        520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`y^2 (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`x^2 (6.25*^6 - 
        1.25*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -1.3020833333333335`*^6 + \
$CellContext`y^2 (5.208333333333334*^6 - 2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-520833.33333333326` + $CellContext`y^2 (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -520833.3333333335 + \
(-5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + \
$CellContext`y^2 (-5.208333333333334*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-6.25*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        5.208333333333334*^6 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`y) - 
       2.0833333333333333`*^6 $CellContext`y) (0.5 + 1. $CellContext`z)^2, (
        0.5 - 1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x \
(-1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`z) - 
       2.0833333333333333`*^6 $CellContext`z), 
      3.6458333333333335`*^6 + $CellContext`z (1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`y \
(-1.1458333333333334`*^7 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x (
        6.25*^6 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        6.25*^6 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`y + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, (0.5 - 1. $CellContext`y)^2 (
       5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`z + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`z (
        5.208333333333334*^6 + $CellContext`x (-1.25*^7 + $CellContext`x \
(-1.25*^7 - 1.25*^7 $CellContext`z) - 1.25*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z), \
(-1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) - 
       1.041666666666667*^7 $CellContext`y) (0.5 + 1. $CellContext`z)^2, 
      1.3020833333333335`*^6 + $CellContext`y^2 (-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        2.604166666666667*^6 + $CellContext`y^2 (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`z (-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`x^2 (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`x^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, -260416.66666666663` - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z))}, {-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (-1.25*^7 + 1.25*^7 $CellContext`y) + 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y (6.25*^6 - 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-6.25*^6 + 
          1.25*^7 $CellContext`z^2)), -260416.66666666663` + $CellContext`y (
        520833.33333333326` - 5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      2.0833333333333335`*^6 + $CellContext`x (
        5.208333333333334*^6 + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + $CellContext`x (
          5.208333333333334*^6 + (1.25*^7 - 
            1.25*^7 $CellContext`y) $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`x) $CellContext`x + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, \
-260416.66666666663` + $CellContext`y (520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), 260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -2.0833333333333335`*^6 + \
$CellContext`x (-1.1458333333333334`*^7 + 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`y^2)) + 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (
          3.3333333333333336`*^7 + 3.3333333333333336`*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, 1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`x^2 (
        1.1458333333333334`*^7 - 1.25*^7 $CellContext`y^2 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y^2 (6.25*^6 - 
        1.25*^7 $CellContext`z^2), 1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), (-1.0416666666666665`*^6 + \
$CellContext`x (1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`y) + 
       2.0833333333333333`*^6 $CellContext`y) (0.5 + 1. $CellContext`z)^2, 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`z (5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`z + $CellContext`y (
          1.25*^7 + $CellContext`y (-1.25*^7 - 1.25*^7 $CellContext`z) + 
          1.25*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), (-5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`y + $CellContext`x \
(-1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, 
      3.6458333333333335`*^6 + $CellContext`z (1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`y (-6.25*^6 + \
(-1.25*^7 - 1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y^2 (
        6.25*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x (
        1.1458333333333334`*^7 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (-1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 \
(-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) - 
       1.041666666666667*^7 $CellContext`y) (0.5 + 
        1. $CellContext`z)^2, -520833.3333333335 + (-5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + $CellContext`x \
(-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), 
      260416.66666666663` + $CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z), (5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, -2.0833333333333335`*^6 + $CellContext`z \
(-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`y^2 (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z))}, {(0.5 - 
        1. $CellContext`y)^2 (-5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + 
        1.25*^7 $CellContext`z^2) + $CellContext`y (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`z^2)), (0.5 - 
        1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x \
(-2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`z) - 
       1.041666666666667*^7 $CellContext`z), 
      260416.66666666663` + $CellContext`y (-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        1.0416666666666665`*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), -520833.3333333335 + \
(-5.208333333333335*^6 - 5.208333333333335*^6 $CellContext`x) $CellContext`x + 
      5.208333333333334*^6 $CellContext`y + $CellContext`x (
        3.3333333333333332`*^7 + 
        3.3333333333333332`*^7 $CellContext`x) $CellContext`y + \
(-5.208333333333333*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333332`*^7 $CellContext`x) $CellContext`x) \
$CellContext`y^2 - 
      6.25*^6 $CellContext`z^2 + ((-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, \
-260416.66666666663` - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y^2 (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x \
(-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 + 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
          3.3333333333333336`*^7 $CellContext`y^2)) + ($CellContext`x (
          1.25*^7 + 1.25*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        520833.33333333326` + $CellContext`y^2 (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 
      1.3020833333333335`*^6 + $CellContext`x^2 (-5.208333333333334*^6 + \
$CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      6.25*^6 $CellContext`z^2 + $CellContext`y^2 (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2) + $CellContext`x^2 (1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), (
        0.5 - 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (-1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`z) + 
       2.0833333333333333`*^6 $CellContext`z), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        1.0416666666666668`*^7 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + (
          3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y \
(-5.208333333333334*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z) + $CellContext`y (
          5.208333333333334*^6 + (-1.25*^7 - 
            1.25*^7 $CellContext`z) $CellContext`z)), (0.5 - 
        1. $CellContext`y)^2 (5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`z + $CellContext`x (
         1.041666666666667*^7 + 
         2.083333333333334*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 \
(-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (6.25*^6 + 
        6.25*^6 $CellContext`z) + $CellContext`y (-1.1458333333333334`*^7 + \
(-1.25*^7 - 1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x (
        1.1458333333333334`*^7 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (-3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)), 
      1.3020833333333335`*^6 + $CellContext`y^2 (-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        2.604166666666667*^6 + $CellContext`y^2 (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -260416.66666666663` + \
$CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z, 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + \
(-1.25*^7 - 1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), 
      260416.66666666663` + $CellContext`y^2 (-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (-2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      520833.3333333335 + (-6.25*^6 - 
        6.25*^6 $CellContext`z) $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z))}, {-3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`y^2 (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`x^2 (6.25*^6 - 
        1.25*^7 $CellContext`y^2 - 
        1.25*^7 $CellContext`z^2), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -1.3020833333333335`*^6 + \
$CellContext`y^2 (5.208333333333334*^6 - 2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-520833.33333333326` + $CellContext`y^2 (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 520833.3333333335 - 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
          1.25*^7 $CellContext`y^2)) - 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (1.25*^7 + 
          1.25*^7 $CellContext`x) + 
        3.3333333333333336`*^7 $CellContext`y^2) $CellContext`z^2, 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      260416.66666666663` - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y^2 \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x (
        520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y (
        5.208333333333334*^6 + $CellContext`x (-1.25*^7 + $CellContext`x \
(-1.25*^7 - 1.25*^7 $CellContext`y) - 1.25*^7 $CellContext`y) + 
        5.208333333333334*^6 $CellContext`y) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y) \
$CellContext`z^2, 1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), (
        0.5 + 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`z) - 
       1.041666666666667*^7 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`y (-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`y + $CellContext`x^2 (1.25*^7 + 
          1.25*^7 $CellContext`y)) + 
      5.208333333333334*^6 $CellContext`z^2 + (
        1.25*^7 $CellContext`x^2 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y)) $CellContext`z^2, \
-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), (0.5 + 
        1. $CellContext`y)^2 (-5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x \
(-2.0833333333333333`*^6 + 
         2.083333333333334*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`z (-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`x^2 (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`x^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, -260416.66666666663` - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`z (
        5.208333333333334*^6 + $CellContext`x (-1.25*^7 + $CellContext`x \
(-1.25*^7 - 1.25*^7 $CellContext`z) - 1.25*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z), (
       1.0416666666666665`*^6 + $CellContext`x (2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) - 
       1.041666666666667*^7 $CellContext`y) (0.5 + 1. $CellContext`z)^2, 
      1.3020833333333335`*^6 + $CellContext`y^2 (-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        2.604166666666667*^6 + $CellContext`y^2 (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 
      3.6458333333333335`*^6 + $CellContext`z (1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`x (
        6.25*^6 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        6.25*^6 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y (
        1.1458333333333334`*^7 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`y + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, (0.5 + 1. $CellContext`y)^2 (
       5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`z + $CellContext`x (
         1.041666666666667*^7 + 
         2.083333333333334*^7 $CellContext`z)), -520833.3333333335 + \
(-5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + $CellContext`y \
(-5.208333333333334*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-5.208333333333334*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          
          1.25*^7 $CellContext`z) $CellContext`z), (-1.0416666666666665`*^6 + \
$CellContext`x (-1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`y) - 
       2.0833333333333333`*^6 $CellContext`y) (0.5 + 1. $CellContext`z)^2, (
        0.5 + 1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x \
(-1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`z) - 
       2.0833333333333333`*^6 $CellContext`z)}, {-1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`x^2 (
        1.1458333333333334`*^7 - 1.25*^7 $CellContext`y^2 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y^2 (6.25*^6 - 
        1.25*^7 $CellContext`z^2), -1.3020833333333335`*^6 + $CellContext`x^2 \
(5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -2.0833333333333335`*^6 + \
$CellContext`x (-1.1458333333333334`*^7 + 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`y^2)) + 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (
          3.3333333333333336`*^7 + 3.3333333333333336`*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, -1.3020833333333335`*^6 + 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      2.0833333333333335`*^6 + $CellContext`x (
        5.208333333333334*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + $CellContext`x (
          5.208333333333334*^6 + (-1.25*^7 - 
            1.25*^7 $CellContext`y) $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`x) $CellContext`x + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, 
      260416.66666666663` + $CellContext`x (
        1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`y (
        520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z, 260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (1.25*^7 + 1.25*^7 $CellContext`y) + 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y (-6.25*^6 + 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-6.25*^6 + 
          1.25*^7 $CellContext`z^2)), 
      260416.66666666663` + $CellContext`y (520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, -2.0833333333333335`*^6 + $CellContext`z \
(-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`y^2 (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (-2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), (-1.0416666666666665`*^6 + \
$CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) - 
       1.041666666666667*^7 $CellContext`y) (0.5 + 
        1. $CellContext`z)^2, -520833.3333333335 + (-5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + $CellContext`x \
(-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), -260416.66666666663` + \
$CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z, (5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`y + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, 
      3.6458333333333335`*^6 + $CellContext`z (1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`y (
        6.25*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        6.25*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x (
        1.1458333333333334`*^7 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 1.3020833333333335`*^6 + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (-1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`y) + 
       2.0833333333333333`*^6 $CellContext`y) (0.5 + 1. $CellContext`z)^2, 
      2.0833333333333335`*^6 + $CellContext`z (
        5.208333333333334*^6 + $CellContext`y (-1.25*^7 + $CellContext`y \
(-1.25*^7 - 1.25*^7 $CellContext`z) - 1.25*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z), 
      1.3020833333333335`*^6 + $CellContext`x^2 (-5.208333333333334*^6 + \
$CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z)}, {-1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 (
        5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x (
        520833.33333333326` + $CellContext`y^2 (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      6.25*^6 $CellContext`z^2 + $CellContext`y^2 (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2) + $CellContext`x^2 (1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 - 
        1.25*^7 $CellContext`z^2), -260416.66666666663` - 
      2.604166666666667*^6 $CellContext`z + $CellContext`y^2 (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x \
(-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 \
(-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
          3.3333333333333336`*^7 $CellContext`y^2)) + ($CellContext`x (
          1.25*^7 + 1.25*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, (0.5 + 
        1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x \
(-2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`z) - 
       1.041666666666667*^7 $CellContext`z), -260416.66666666663` + \
$CellContext`x (-1.0416666666666665`*^6 + $CellContext`y \
(-2.083333333333333*^6 - 2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`y \
(-520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z, -520833.3333333335 + \
(-5.208333333333335*^6 - 5.208333333333335*^6 $CellContext`x) $CellContext`x - 
      5.208333333333334*^6 $CellContext`y + (-3.3333333333333332`*^7 - 
        3.3333333333333332`*^7 $CellContext`x) $CellContext`x $CellContext`y + \
(-5.208333333333333*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333332`*^7 $CellContext`x) $CellContext`x) \
$CellContext`y^2 - 
      6.25*^6 $CellContext`z^2 + ((-1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, (0.5 + 
        1. $CellContext`y)^2 (-5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x (
         2.0833333333333333`*^6 + 
         2.083333333333334*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (-520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + 
        1.25*^7 $CellContext`z^2) + $CellContext`y (-1.1458333333333334`*^7 + 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`z^2)), 
      260416.66666666663` + $CellContext`y^2 (-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      520833.3333333335 + (-6.25*^6 - 
        6.25*^6 $CellContext`z) $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)), 
      1.3020833333333335`*^6 + $CellContext`y^2 (-5.208333333333334*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        2.604166666666667*^6 + $CellContext`y^2 (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), 
      260416.66666666663` + $CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + \
(-1.25*^7 - 1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), (0.5 + 
        1. $CellContext`y)^2 (5.208333333333335*^6 + 
       1.041666666666667*^7 $CellContext`z + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`z)), 
      1.3020833333333335`*^6 + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)) + $CellContext`x^2 (
        5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (6.25*^6 + 
        6.25*^6 $CellContext`z) + $CellContext`y (
        1.1458333333333334`*^7 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x (
        1.1458333333333334`*^7 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)), (0.5 + 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (-1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`z) + 
       2.0833333333333333`*^6 $CellContext`z), 
      1.3020833333333335`*^6 + $CellContext`x^2 (-5.208333333333334*^6 + \
$CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 5.208333333333334*^6 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + \
(-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        5.208333333333334*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z + $CellContext`y (
          5.208333333333334*^6 + (-1.25*^7 - 
            1.25*^7 $CellContext`z) $CellContext`z))}, {
     520833.3333333335 - 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (6.25*^6 - 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-6.25*^6 + 
          1.25*^7 $CellContext`y^2)) - 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x (-1.25*^7 + 
          1.25*^7 $CellContext`x) + 
        3.3333333333333336`*^7 $CellContext`y^2) $CellContext`z^2, \
-260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -260416.66666666663` + \
$CellContext`y^2 (1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`y^2 (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`x^2 (6.25*^6 - 
        1.25*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-520833.33333333326` + $CellContext`y^2 (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`y (-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`y + $CellContext`x^2 (1.25*^7 + 
          1.25*^7 $CellContext`y)) + 
      5.208333333333334*^6 $CellContext`z^2 + (
        1.25*^7 $CellContext`x^2 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y)) $CellContext`z^2, 
      260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), (0.5 + 
        1. $CellContext`y)^2 (5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y (5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`y + $CellContext`x (
          1.25*^7 + $CellContext`x (-1.25*^7 - 1.25*^7 $CellContext`y) + 
          1.25*^7 $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y) \
$CellContext`z^2, -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), (
        0.5 + 1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x (
         2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`z) + 
       1.041666666666667*^7 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + (
          1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`z (5.208333333333334*^6 + 
        5.208333333333334*^6 $CellContext`z + $CellContext`x (
          1.25*^7 + $CellContext`x (-1.25*^7 - 1.25*^7 $CellContext`z) + 
          1.25*^7 $CellContext`z)), (-1.0416666666666665`*^6 + $CellContext`x \
(2.0833333333333333`*^6 - 2.083333333333334*^7 $CellContext`y) + 
       1.041666666666667*^7 $CellContext`y) (0.5 + 
        1. $CellContext`z)^2, -1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        2.604166666666667*^6 + $CellContext`y^2 (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 (
        5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z), -2.0833333333333335`*^6 + \
$CellContext`z (-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`x^2 (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`x^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (5.208333333333335*^6 - 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x \
(-2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, 
      260416.66666666663` + $CellContext`y^2 (-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x \
(-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), -520833.3333333335 + \
(-5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + $CellContext`y \
(-5.208333333333334*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-5.208333333333334*^6 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`x^2 (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z), (
       1.0416666666666665`*^6 + $CellContext`x (-1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`y) + 
       2.0833333333333333`*^6 $CellContext`y) (0.5 + 1. $CellContext`z)^2, (
        0.5 + 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (-1.041666666666667*^7 - 
         2.083333333333334*^7 $CellContext`z) + 
       2.0833333333333333`*^6 $CellContext`z), 
      3.6458333333333335`*^6 + $CellContext`z (1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`x (-6.25*^6 + \
(-1.25*^7 - 1.25*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        6.25*^6 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y (
        1.1458333333333334`*^7 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), (-5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`y + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, (0.5 + 
        1. $CellContext`y)^2 (-5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`z + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`z))}, {
     260416.66666666663` - 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 
          2.0833333333333336`*^7 $CellContext`z^2)), -2.0833333333333335`*^6 + \
$CellContext`x (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`y^2 + $CellContext`x (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`y^2)) + 
      5.208333333333334*^6 $CellContext`z^2 + ($CellContext`x \
(-3.3333333333333336`*^7 + 3.3333333333333336`*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, -1.3020833333333335`*^6 + \
$CellContext`x (
        5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x (
        520833.33333333326` - 
        2.083333333333333*^6 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 
          2.0833333333333336`*^7 $CellContext`z^2)), -3.6458333333333335`*^6 + 
      1.1458333333333334`*^7 $CellContext`z^2 + $CellContext`x^2 (
        1.1458333333333334`*^7 - 1.25*^7 $CellContext`y^2 - 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y^2 (6.25*^6 - 
        1.25*^7 $CellContext`z^2), -1.3020833333333335`*^6 + $CellContext`x^2 \
(5.208333333333334*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`y \
(-520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -260416.66666666663` + 
      1.0416666666666665`*^6 $CellContext`z^2 + $CellContext`y \
(-520833.33333333326` + 
        2.083333333333333*^6 $CellContext`z^2) + $CellContext`x \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y \
(-5.208333333333334*^6 + 2.0833333333333336`*^7 $CellContext`z^2)), 
      520833.3333333335 - 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`x^2 \
(-5.208333333333334*^6 + $CellContext`y (1.25*^7 + 1.25*^7 $CellContext`y) + 
        3.3333333333333336`*^7 $CellContext`z^2) + $CellContext`y (-6.25*^6 + 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-6.25*^6 + 
          1.25*^7 $CellContext`z^2)), 
      260416.66666666663` + $CellContext`y (520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 + 
      5.208333333333334*^6 $CellContext`z^2 + $CellContext`y \
(-2.604166666666667*^6 + 
        1.0416666666666668`*^7 $CellContext`z^2) + $CellContext`x (
        2.604166666666667*^6 - 
        1.0416666666666668`*^7 $CellContext`z^2 + $CellContext`y (
          5.208333333333334*^6 - 2.0833333333333336`*^7 $CellContext`z^2)), 
      2.0833333333333335`*^6 + $CellContext`x (-5.208333333333334*^6 + \
$CellContext`y (1.25*^7 + 1.25*^7 $CellContext`y) + $CellContext`x (
          5.208333333333334*^6 + (-1.25*^7 - 
            1.25*^7 $CellContext`y) $CellContext`y)) - 
      1.1458333333333334`*^7 $CellContext`z^2 + ((3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`x) $CellContext`x + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, 
      260416.66666666663` + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`y (
        520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y \
(-2.083333333333333*^6 + 2.0833333333333336`*^7 $CellContext`z)), (
       1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`y) + 
       1.041666666666667*^7 $CellContext`y) (0.5 + 
        1. $CellContext`z)^2, -520833.3333333335 + (-5.208333333333334*^6 - 
        5.208333333333334*^6 $CellContext`z) $CellContext`z + \
$CellContext`x^2 (-5.208333333333334*^6 - 
        1.25*^7 $CellContext`y^2 + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y^2 (-6.25*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x (
        5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        2.083333333333333*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), (
       5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`y + $CellContext`x (
         2.0833333333333333`*^6 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, -2.0833333333333335`*^6 + $CellContext`z \
(-1.1458333333333334`*^7 - 
        1.1458333333333334`*^7 $CellContext`z + $CellContext`y^2 (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (5.208333333333334*^6 + 
        1.25*^7 $CellContext`y^2 + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (-2.604166666666667*^6 - 5.208333333333334*^6 $CellContext`z) - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 
          2.0833333333333336`*^7 $CellContext`z)), (-1.0416666666666665`*^6 + \
$CellContext`x (-1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`y) - 
       2.0833333333333333`*^6 $CellContext`y) (0.5 + 1. $CellContext`z)^2, 
      2.0833333333333335`*^6 + $CellContext`z (
        5.208333333333334*^6 + $CellContext`y (-1.25*^7 + $CellContext`y \
(-1.25*^7 - 1.25*^7 $CellContext`z) - 1.25*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z), 
      1.3020833333333335`*^6 + $CellContext`x^2 (-5.208333333333334*^6 + \
$CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z), (-5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`y + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`y)) (0.5 + 
        1. $CellContext`z)^2, 
      3.6458333333333335`*^6 + $CellContext`z (1.1458333333333334`*^7 + 
        1.1458333333333334`*^7 $CellContext`z) + $CellContext`x \
(-1.1458333333333334`*^7 + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y + (-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`z) $CellContext`z) + \
$CellContext`y (
        6.25*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        6.25*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (1.25*^7 + 
          1.25*^7 $CellContext`y) + $CellContext`z (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`z)), 
      1.3020833333333335`*^6 + $CellContext`x (-5.208333333333334*^6 + \
$CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z))}, {
     260416.66666666663` + $CellContext`y^2 (-1.0416666666666665`*^6 - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`x \
(-520833.33333333326` - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x (
        5.208333333333334*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 \
(-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + 
      5.208333333333334*^6 $CellContext`y^2 + $CellContext`x (
        1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`x \
(-1.1458333333333334`*^7 + 
          3.3333333333333336`*^7 $CellContext`y^2)) + ($CellContext`x \
(-1.25*^7 + 1.25*^7 $CellContext`x) + 
        1.25*^7 $CellContext`y^2) $CellContext`z^2, 
      1.3020833333333335`*^6 + $CellContext`y^2 (-5.208333333333334*^6 - 
        2.083333333333333*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x (
        520833.33333333326` + $CellContext`y^2 (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z), -1.3020833333333335`*^6 - 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (-2.083333333333333*^6 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`y (
        520833.33333333326` + 
        5.208333333333334*^6 $CellContext`z), -3.6458333333333335`*^6 + 
      6.25*^6 $CellContext`z^2 + $CellContext`y^2 (1.1458333333333334`*^7 - 
        1.25*^7 $CellContext`z^2) + $CellContext`x^2 (1.1458333333333334`*^7 - 
        3.3333333333333336`*^7 $CellContext`y^2 - 1.25*^7 $CellContext`z^2), (
        0.5 + 1. $CellContext`y)^2 (5.208333333333335*^6 + 
       2.0833333333333333`*^6 $CellContext`z + $CellContext`x (
         2.0833333333333333`*^6 + 
         2.083333333333334*^7 $CellContext`z)), -260416.66666666663` + \
$CellContext`y (-520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -2.0833333333333335`*^6 + \
$CellContext`x^2 (
        5.208333333333334*^6 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + 
        1.25*^7 $CellContext`z^2) + $CellContext`y (-1.1458333333333334`*^7 + 
        1.25*^7 $CellContext`z^2 + $CellContext`y (-1.1458333333333334`*^7 + 
          1.25*^7 $CellContext`z^2)), (0.5 + 1. $CellContext`y)^2 (
       1.0416666666666665`*^6 + $CellContext`x (-2.0833333333333333`*^6 - 
         2.083333333333334*^7 $CellContext`z) + 
       1.041666666666667*^7 $CellContext`z), -260416.66666666663` + \
$CellContext`x^2 (-1.0416666666666665`*^6 + $CellContext`y \
(-2.083333333333333*^6 - 2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + $CellContext`y \
(-520833.33333333326` - 5.208333333333334*^6 $CellContext`z) - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        1.0416666666666665`*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          2.083333333333333*^6 + 
          2.0833333333333336`*^7 $CellContext`z)), -520833.3333333335 + (
        5.208333333333335*^6 - 
        5.208333333333335*^6 $CellContext`x) $CellContext`x - 
      5.208333333333334*^6 $CellContext`y + (3.3333333333333332`*^7 - 
        3.3333333333333332`*^7 $CellContext`x) $CellContext`x $CellContext`y + \
(-5.208333333333334*^6 + (3.3333333333333336`*^7 - 
          3.3333333333333332`*^7 $CellContext`x) $CellContext`x) \
$CellContext`y^2 - 
      6.25*^6 $CellContext`z^2 + ((1.25*^7 - 
          1.25*^7 $CellContext`x) $CellContext`x + (-1.25*^7 - 
          1.25*^7 $CellContext`y) $CellContext`y) $CellContext`z^2, \
-1.3020833333333335`*^6 - 
      2.604166666666667*^6 $CellContext`z + $CellContext`x (
        2.604166666666667*^6 + $CellContext`y^2 (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`y^2 (
        5.208333333333334*^6 + 1.0416666666666668`*^7 $CellContext`z), 
      260416.66666666663` + $CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 (
        1.0416666666666665`*^6 + $CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      2.0833333333333335`*^6 + $CellContext`y^2 (-1.1458333333333334`*^7 + \
(-1.25*^7 - 1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 - 
        3.3333333333333336`*^7 $CellContext`y^2 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`x \
(-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)), -260416.66666666663` - 
      520833.33333333326` $CellContext`z + $CellContext`y^2 (
        1.0416666666666665`*^6 + 
        2.083333333333333*^6 $CellContext`z) + $CellContext`x \
(-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z + $CellContext`y^2 (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      260416.66666666663` + $CellContext`y (-2.604166666666667*^6 - 
        5.208333333333334*^6 $CellContext`z) + 
      520833.33333333326` $CellContext`z + $CellContext`x^2 \
(-1.0416666666666665`*^6 - 
        2.083333333333333*^6 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      520833.3333333335 + (-6.25*^6 - 
        6.25*^6 $CellContext`z) $CellContext`z + $CellContext`y^2 \
(-5.208333333333334*^6 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (-5.208333333333334*^6 + 
        3.3333333333333336`*^7 $CellContext`y^2 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)), (0.5 + 
        1. $CellContext`y)^2 (-1.0416666666666665`*^6 + $CellContext`x \
(-1.041666666666667*^7 - 2.083333333333334*^7 $CellContext`z) - 
       2.0833333333333333`*^6 $CellContext`z), 
      1.3020833333333335`*^6 + $CellContext`x^2 (-5.208333333333334*^6 + \
$CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 5.208333333333334*^6 $CellContext`z), 
      2.0833333333333335`*^6 + $CellContext`x^2 (-1.1458333333333334`*^7 + \
(-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        5.208333333333334*^6 + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z + $CellContext`y (
          5.208333333333334*^6 + (-1.25*^7 - 
            1.25*^7 $CellContext`z) $CellContext`z)), (0.5 + 
        1. $CellContext`y)^2 (-5.208333333333335*^6 - 
       1.041666666666667*^7 $CellContext`z + $CellContext`x (
         1.041666666666667*^7 + 2.083333333333334*^7 $CellContext`z)), 
      1.3020833333333335`*^6 + $CellContext`x (-5.208333333333334*^6 + \
$CellContext`y (-1.0416666666666668`*^7 - 
          2.0833333333333336`*^7 $CellContext`z) - 
        1.0416666666666668`*^7 $CellContext`z) + 
      2.604166666666667*^6 $CellContext`z + $CellContext`y (
        2.604166666666667*^6 + 
        5.208333333333334*^6 $CellContext`z) + $CellContext`x^2 (
        5.208333333333334*^6 + 
        1.0416666666666668`*^7 $CellContext`z + $CellContext`y (
          1.0416666666666668`*^7 + 2.0833333333333336`*^7 $CellContext`z)), 
      3.6458333333333335`*^6 + $CellContext`z (6.25*^6 + 
        6.25*^6 $CellContext`z) + $CellContext`x (-1.1458333333333334`*^7 + \
(-3.3333333333333336`*^7 - 
          3.3333333333333336`*^7 $CellContext`y) $CellContext`y + (-1.25*^7 - 
          1.25*^7 $CellContext`z) $CellContext`z) + $CellContext`y (
        1.1458333333333334`*^7 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`y^2 (
        1.1458333333333334`*^7 + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z)) + $CellContext`x^2 (
        1.1458333333333334`*^7 + $CellContext`y (3.3333333333333336`*^7 + 
          3.3333333333333336`*^7 $CellContext`y) + $CellContext`z (1.25*^7 + 
          1.25*^7 $CellContext`z))}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684633791715*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N1 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Zeta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N1 = ", Rational[1, 8] (1 - $CellContext`\[Zeta]) (
    1 - $CellContext`\[Eta]) (1 - $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.8076846337967157`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N2 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Zeta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N2 = ", Rational[1, 8] (1 - $CellContext`\[Zeta]) (
    1 - $CellContext`\[Eta]) (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684633803715*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N3 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Zeta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N3 = ", Rational[1, 8] (1 - $CellContext`\[Zeta]) (
    1 + $CellContext`\[Eta]) (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684633808715*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N4 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Zeta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N4 = ", Rational[1, 8] (1 - $CellContext`\[Zeta]) (
    1 + $CellContext`\[Eta]) (1 - $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684633816715*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N5 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Zeta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N5 = ", Rational[1, 8] (1 + $CellContext`\[Zeta]) (
    1 - $CellContext`\[Eta]) (1 - $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684633820714*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N6 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Zeta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N6 = ", Rational[1, 8] (1 + $CellContext`\[Zeta]) (
    1 - $CellContext`\[Eta]) (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.806558639715878*^9, 3.806558768228094*^9, 3.806558942593713*^9, 
   3.806561272388234*^9, 3.806561411168312*^9, 3.8065614645585084`*^9, 
   3.80656191184191*^9, 3.806562413249526*^9, 3.806563694330546*^9, 
   3.806563752923336*^9, 3.80656435722685*^9, 3.806564391022921*^9, 
   3.8065644244538755`*^9, 3.806564485909532*^9, 3.806564528437248*^9, 
   3.8065645822530327`*^9, 3.8065653607568493`*^9, 3.806565426328576*^9, 
   3.8065654996463537`*^9, 3.8065655697772245`*^9, 3.806565916398165*^9, 
   3.806640027536386*^9, 3.8066401564547567`*^9, 3.806644246079201*^9, 
   3.807366919299257*^9, 3.8073671470394187`*^9, 3.807367357132185*^9, 
   3.8073674319282665`*^9, 3.807367512656197*^9, 3.807683719748747*^9, 
   3.8076845339010696`*^9, 3.807684633825714*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N7 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Zeta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N7 = ", Rational[1, 8] (1 + $CellContext`\[Zeta]) (
    1 + $CellContext`\[Eta]) (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7920527822295837`*^9, 3.792055912256052*^9, 3.79205611546189*^9, 
   3.79205627626083*^9, 3.792056412970455*^9, 3.792577973304329*^9, 
   3.7925790440090528`*^9, 3.7925816248160715`*^9, {3.793528632760981*^9, 
   3.7935286621453524`*^9}, 3.793529453397287*^9, 3.7935301691586657`*^9, {
   3.7935302622485476`*^9, 3.79353032606209*^9}, 3.7935303778959036`*^9, 
   3.7935305983158927`*^9, 3.7935309236053324`*^9, 3.793531072715455*^9, {
   3.793531118443644*^9, 3.7935311528066425`*^9}, 3.7935311866134396`*^9, 
   3.793531224376137*^9, 3.7935320055783644`*^9, {3.7935320940955944`*^9, 
   3.793532123173291*^9}, 3.7935322940978203`*^9, 3.7935456480421977`*^9, 
   3.793546869589504*^9, 3.7935469932664766`*^9, 3.793547209573113*^9, 
   3.793547603462363*^9, 3.793547656277134*^9, 3.793547825085726*^9, 
   3.7935484840253806`*^9, {3.7935485178350687`*^9, 3.7935485544518256`*^9}, 
   3.7935486046803565`*^9, {3.793549095640693*^9, 3.793549118349777*^9}, 
   3.7935491618220367`*^9, 3.793549604673785*^9, 3.79354972570242*^9, {
   3.793550021048649*^9, 3.7935500316622453`*^9}, 3.7935501353741655`*^9, 
   3.7935505428041377`*^9, 3.793550684827975*^9, 3.7935507610046496`*^9, 
   3.7935516352727304`*^9, 3.793551723422736*^9, {3.7935519102383757`*^9, 
   3.7935519318003244`*^9}, 3.7935520755520477`*^9, 3.793552231061652*^9, 
   3.7935522824796076`*^9, 3.793552345706072*^9, 3.7935537059603214`*^9, 
   3.7935608802514367`*^9, 3.793561154421047*^9, {3.7935611892451725`*^9, 
   3.7935612137914906`*^9}, 3.7935613925914464`*^9, 3.793561758022105*^9, 
   3.793594430395483*^9, 3.793594467799765*^9, 3.7935945328460093`*^9, 
   3.793595404882019*^9, 3.79359552462984*^9, 3.793595573570448*^9, 
   3.7935957489886274`*^9, 3.793595802259672*^9, 3.793595888172715*^9, 
   3.793595961707068*^9, 3.793596017151293*^9, 3.7935965494560795`*^9, 
   3.79359660098339*^9, 3.7935966340097237`*^9, {3.7935967715700502`*^9, 
   3.7935967887396784`*^9}, 3.7935970923361964`*^9, {3.793599904035289*^9, 
   3.793599918267108*^9}, 3.7936000020277615`*^9, {3.793600146006809*^9, 
   3.7936001598319902`*^9}, 3.79364737426222*^9, 3.7936477127544365`*^9, {
   3.805768097606865*^9, 3.8057681212601633`*^9}, 3.8057683368328557`*^9, 
   3.805768444771747*^9, {3.8057686218379836`*^9, 3.805768640565539*^9}, {
   3.805768702421338*^9, 3.805768714103311*^9}, 3.805769790207156*^9, 
   3.805770053946071*^9, 3.8061543714600835`*^9, 3.8061544945528774`*^9, 
   3.806553520906844*^9, 3.806554796733914*^9, 3.8065549550133*^9, 
   3.806555218363769*^9, 3.8065558471195354`*^9, 3.8065563641841803`*^9, 
   3.8065574211809387`*^9, 3.8065574698940783`*^9, 3.8065576606027775`*^9, 
   3.8065583362169485`*^9, 3.806558412406824*^9, 3.80655849884816*^9, 
   3.8065586397